/*!
 * FSI Viewer (tm)
 * Build: 20.10.3324
 * 
 * Copyright (c) 2020 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2020",strBuild:"20.10.3324",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.setRendererInURL=function(url,strRenderer){if(url.match(regExServerRenderer)){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer)}else{if(url.indexOf("?")===-1){url+="?"}else{url+="&"}url+="renderer="+strRenderer}return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlEncode=function(str){if(!str){return str}try{str=encodeURIComponent(str)}catch(e){$FSI.console.error("Malformed URI: "+str)}str=str.replace(regexPlusToSpace,"%2B");return str};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.initCustomNode=function(i){if(f||!i||!i.tagName){return false}const h=g[i.tagName.toLowerCase()];if(!h){console.error("$FSI.initCustomTag: invalid node type "+i.tagName);return}h.replaceTagInit();h.replaceTag(i,h)};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag;a.initCustomNode=a.customTags.initCustomNode}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!==b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.utils.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m===b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m===b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(){if(k.readyState!==4){return}delete c[n];if(m===b||this.FSIaborted){return}var e=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,e,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){if(c.hasOwnProperty(k)){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CanvasProgressBar!==b){return}a.CanvasProgressBar=function(s,m,j,d,q,e){var r=this;if(!e){e={}}if(typeof(e.border)!="string"){e.frame="#58a8ff"}if(typeof(e.color)!="string"){e.color="#58a8ff"}if(typeof(e.background)!="string"){e.background="rgba(255,255,255,0.5)"}if(typeof(e.text)!="string"){e.text="#FFFFFF"}var p=m;var o=j;var g=q;var l=d;var h=0;var k=(q>10&&d>40);this.draw=function(t){var u=l/100*t;i(p,o,l,g,h);c(p,o,u,g,h,l);if(k){f(p,o,u,g,h,l)}};this.setCtx=function(t){s=t};this.setPos=function(t,u){p=t;o=u};var i=function(v,z,w,u,t){s.save();s.fillStyle=e.border;n(v-1,z-1,w+2,1,t);n(v-1,z+u,w+2,1,t);n(v-1,z-1,1,u+2,t);n(v+w,z-1,1,u+2,t);s.fillStyle=e.background;n(v,z,w,u,t);s.restore()};var c=function(v,z,w,u,t){s.fillStyle=e.color;n(v,z,w,u,t)};var n=function(u,w,v,t){s.fillRect(u,w,v,t)};var f=function(B,z,t,D,w,A){s.save();s.font="10px Arial";s.textAlign="start";s.textBaseline="alphabetic";s.fillStyle=e.text;var C=Math.floor(t/A*100)+"%";var u=s.measureText(C).width;var v=B+t-u-w/2-4;if(t<=w+u){v=B+w/2}s.fillText(C,v,z+D/2+3.25);s.restore()}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim];if(az.bForceWidthAndHeight===true){ar.width=at.width;ar.height=at.height}else{ar[at.dim]=at[at.dim]}}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=decodeURIComponent(ay[0]).toLowerCase();if(ax.length>0){ar=decodeURIComponent(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){if(typeof(av)!=="string"||av.length<1){if(ar){ar(null,"",au)}}else{var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)}};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=decodeURIComponent(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"src"))}if(!aK){aK=decodeURIComponent(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(av){var aC,az,aw;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var aA=n.cfg.fpxsources;if(typeof(aA)==="string"||(typeof(aA)==="object")&&typeof(aA.push)==="function"){aC={};aC.oXML=null;if(typeof(aA)==="string"){if(ae===false){aC.arImages=aA.split(",");for(az=0;az<aC.arImages.length;az++){aC.arImages[az]=decodeURIComponent(aC.arImages[az])}}else{var ay=aA.split(",");aC.arImages=[];for(az=0;az<ay.length;az++){aw=decodeURIComponent(ay[az]);if(ae(aw)){aC.arImages.push(aw)}}}}else{aC.arImages=aA}}}if(!aC&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aD=n.arUnrecognizedConfigNodes;for(az=0;az<aD.length;az++){var ax=aD[az];if(typeof(ax.nodeName)==="string"){var au=ax.nodeName.toLowerCase();if(au==="images"||au==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+ax.nodeName+">")}aC=S(ax,av);aC.oXML=ax;break}}}}}if(!aC&&n.cfg&&n.cfg.fpxsrc!==b){aC={};aC.oXML=null;var at=n.cfg.fpxsrc;try{at=decodeURIComponent(at)}catch(aB){}if(ae===false){aC.arImages=[at]}else{if(ae(aw)){aC.arImages=[at]}}}return aC};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}aw=decodeURIComponent(aw);A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=aF.innerHTML}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(n.locationFSIViewer+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=n.locationFSIViewer+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!==b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.setFromArray=function(h){e.left=h[0];e.top=h[1];e.right=h[2];e.bottom=h[3]};this.scaleRect=function(h){if(h===1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h===1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.getPartialRect=function(j){var i=e.duplicateRect();if(!j.isDefaultImageRect()){var h=i.width();var k=i.height();i.offsetRect(j.left*h,j.top*k);i.right=i.left+h*j.width();i.bottom=i.top+k*j.height()}return i};this.isDefaultImageRect=function(){return(e.left===0&&e.top===0&&e.right===1&&e.bottom===1)};this.limitToImageRect=function(){e.left=Math.max(0,Math.min(1,e.left));e.right=Math.max(0,Math.min(1,e.right));e.top=Math.max(0,Math.min(1,e.top));e.bottom=Math.max(0,Math.min(1,e.bottom))};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left===h.left&&e.top===h.top&&e.right===h.right&&e.bottom===h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.setFromString=function(j){if(typeof(j)!=="string"){return}j=decodeURIComponent(j);j=j.replace(/[^0-9,.]/g,"");j=j.split(",");if(j.length>3){for(var h=0;h<j.length;h++){j[h]=parseFloat(j[h])}e.setFromArray(j)}};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!==b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!==b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!==b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!==0||u!==0||v!==0||q!==0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!==-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!==-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!==b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!==b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r===b&&u===b){r=i.width();u=i.height();A=1}else{if(r!==b){A=i.width()/r;if(u===b){u=i.height()/A}}else{A=i.height()/u;if(r===b){r=i.width()/A}}}if(z===b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left===0&&v.top===0&&v.width()===v._refWidth&&v.height()===v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left===0&&r.top===0&&r.width()===r._refWidth&&r.height()===r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,B){var C=new a.CroppedImage();var D,v;if(typeof(y)!=="string"||y.length!==2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var A;var z=p.isCropped();var q,E;var x,F;if(z){x=(1-h.left-h.right);F=(1-h.top-h.bottom);q=Math.round(x*c.width);E=Math.round(F*c.height)}else{q=c.width;E=c.height}u=Math.min(u,q);s=Math.min(s,E);if(u/q<s/E){v=s;D=Math.round(q/E*s);t=D-u;switch(y.charAt(1)){case"l":r.setRect(0,0,D-t,v);break;case"r":r.setRect(t,0,D,v);break;case"v":A=Math.random()*t;r.setRect(A,0,A+u,v);break;default:r.setRect(t/2,0,D-t/2,v)}}else{D=u;v=Math.round(E/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,D,v-t);break;case"b":r.setRect(0,t,D,v);break;case"v":A=Math.random()*t;r.setRect(0,A,D,A+s);break;default:r.setRect(0,t/2,D,v-t/2)}}r.scaleRectXY(1/D,1/v);if(p.isCropped()){D/=x;v/=F;if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v);r.scaleRectXY(x,F);r.offsetRect(h.left,h.top)}else{if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v)}C.widthUncropped=D;C.heightUncropped=v;C.setCropRect(r.left,r.top,r.right,r.bottom);return C}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(i,m,f,j){var q=this;var l;var o;var g;var k;var n=f.getCallbacks();var d=this.paramCustomSkinClass=m;var c;var p=function(){l=f.getRootContainer();o=f.getParentElement();q.destroy();c=a.getViewerLocation()+"/skins/";if(typeof(m)==="string"){if(m.match(/\.js$/)){var r=a.getViewerLocation()+"/"+m;c=r;c=c.replace(/\/[^/]*$/,"/");a.loadJavascript(r,f.getInstanceID(),q,e)}else{if(typeof(window[m])==="function"){k=new window[m](i,o,h,q)}}}else{if(typeof(m)==="function"){k=new m(i,o,h,q)}}};this.getSkinPath=function(){return c};this.replacePaths=function(r){r=r.replace(/\[fsi-skin-path]/g,c);r=r.replace(/\[fsi-viewer-path]/g,a.getViewerLocation()+"/");return r};this.loadHTMLFragment=function(s,v,t,r){s=q.replacePaths(s);var u=function(z,x){x=q.replacePaths(x);if(v&&typeof(v)==="object"&&v.tagName){if(v.firstChild){var y=document.createElement("div");y.innerHTML=x;if(y.firstChild){for(var w=y.childNodes.length-1;w>-1;w--){v.insertBefore(y.childNodes[w],v.firstChild)}}}else{v.innerHTML=x}}t(x,r)};i.loadFile(s,u,"text/plain; charset=utf-8")};var h=function(s){g=s;if(s&&typeof(s)==="object"&&s.tagName){s.appendChild(l)}if(n.isset("onResize")){var r=f.getElementSpace();n.run("onResize",[r.width,r.height,true,f.getIsFullScreen()])}if(i.onResize){i.onResize({FSI_after_treshold:true})}j.apply(i)};var e=function(){d=d.replace(/\.js$/,"");var r=d.lastIndexOf("/");if(r!==1){d=d.substr(r+1)}if(d.length>0&&typeof(window[d])==="function"){k=new window[d](i,o,h,q)}else{h()}};this.getCustomSkinInstance=function(){return k};this.destroy=function(){if(k&&typeof(k.destroy)==="function"){k.destroy(q);k=b}if(g!==b){g=b;while(o.firstChild){o.removeChild(o.firstChild)}o.appendChild(l)}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!==b){return}a.Sprite=function(l,j,u,p,t,n,g,d){if(!d){d=1}var o=this;var c=0.075;var e;var f=true;var v;var k;var x=1;var m=o.margin={left:0,top:0,right:0,bottom:0};var s={};s.width=j;s.height=u;var q=(t)?"canvas":"div";e=o.element=document.createElement(q);e.setAttribute("draggable","false");if(g){e.className=g}var i="";switch(n){case"inline":break;default:i+="position:absolute;z-index:"+p}a.utils.setStyleAttr(e,i);if(t){o.canvas=o.element;o.canvas.setAttribute("crossorigin","anonymous");o.canvas.setAttribute("width",Math.round(s.width*d));o.canvas.setAttribute("height",Math.round(s.height*d));o.canvas.style.width=s.width+"px";o.canvas.style.height=s.height+"px";o.ctx=o.canvas.getContext("2d")}if(l){l.appendChild(e)}this.remove=function(){if(l){a.removeChild(l,e)}};this.setPos=function(h,w){o.x=h;o.y=w;e.style.marginLeft=h+"px";e.style.marginTop=w+"px"};this.isVisible=function(){return(x>0)};this.show=function(h,w){if(f===h){return}f=h;if(k!==b){cancelAnimationFrame(k);k=b}if(!w){x=e.style.opacity=(h)?1:0;e.style.display=(h)?"block":"none"}else{v=(h)?c:-c;if(h){e.style.display="block"}r()}};this.updateMargins=function(){m=o.margin=a.utils.getElementMargins(e)};this.getClientDim=function(){return a.getElementClientDim(o.element)};this.updateDimension=function(){s=a.getElementClientDim(e)};this.width=function(){return s.width};this.height=function(){return s.height};var r=function(){x+=v;if(v>0){if(x>=1){x=1;k=b}else{k=requestAnimationFrame(r)}}else{if(x<=0){x=0;k=b;e.style.display="none"}else{k=requestAnimationFrame(r)}}e.style.opacity=x};if(!t){this.setSize=function(y,z){s.width=y;s.height=z;if(typeof(y)!=="string"){y+="px"}if(typeof(z)!=="string"){z+="px"}o.element.style.width=y;o.element.style.height=z};this.clear=function(){}}else{this.setSize=function(y,z){s.width=y;s.height=z;o.canvas.width=y;o.canvas.height=z};this.clear=function(){o.ctx.clearRect(0,0,s.width,s.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!==b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,z,v,u,w){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=z;e.bNoAutoBold=w;e.fnGetToolTipText=v;if(l!==b){clearTimeout(l);l=b}if(m!==b){clearTimeout(m)}if(u===b){u=(k)?100:1000}m=setTimeout(f,u)};this.setParentContainer=function(r){q.hide();c=r};var f=function(){if(m!==b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!==b){D=e.fnGetToolTipText(w,i);if(D===b){D=i[w]}}else{D=i[w]}if(D!==b){w=D}else{if(!e.bNoAutoBold){w="<b>"+w+"</b>"}}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G===b){G=0}var F=e.y;if(F===b){F=0}var v;var u=a.getElementClientPos(c);if(e.elSrc){v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!==0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r===b||isNaN(r)||r<1){r=2500}if(l!==b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!==b){clearTimeout(m);m=b}if(l!==b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!==b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen._nIDChangeEvent=0;a.FullScreen._nIDErrorEvent=0;a.FullScreen._eventHandlers={};a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}if(typeof(document[d.exitFullscreen])!=="function"){a.FullScreen.bUseFakeFullScreen=true}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();if(!a.FullScreen.bUseFakeFullScreen){c[a.FullScreen.requestFullscreen]()}else{a.FullScreen._enterFakeFullScreen(c)}};a.FullScreen.quit=function(){a.FullScreen.__init();if(!a.FullScreen._exitFakeFullScreen()&&!a.FullScreen.bUseFakeFullScreen){document[a.FullScreen.exitFullscreen]()}};a.FullScreen._enterFakeFullScreen=function(c){if(!c){return}var f=a.FullScreen.oFake={};f.elParentOriginal=c.parentNode;f.elNextSibling=c.nextSibling;f.el=c;var e,d;e=document.documentElement;f.docScrollLeft=e.scrollLeft;f.docScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;e=document.body;f.bodyScrollLeft=e.scrollLeft;f.bodyScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;d=f.bodyStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box";if(document.documentElement){e=document.documentElement;d=f.documentStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box"}a.FullScreen.bChanging=true;document.body.appendChild(c);a.FullScreen.bChanging=false;a.addEvent(window,"keydown",a.FullScreen._keyDown);a.FullScreen.callHandlers()};a.FullScreen._keyDown=function(c){if(c&&c.key==="Escape"||c.which===27){a.FullScreen.quit()}};a.FullScreen._exitFakeFullScreen=function(){if(!a.FullScreen.oFake){return false}var f=a.FullScreen.oFake;a.FullScreen.bChanging=true;if(f.elParentOriginal){if(f.elNextSibling){f.elParentOriginal.insertBefore(f.el,f.elNextSibling)}else{f.elParentOriginal.appendChild(f.el)}}var e=document.body;var d=f.bodyStyle;var c;for(c in d){if(d.hasOwnProperty(c)){e.style[c]=d[c]}}e.scrollLeft=f.bodyScrollLeft;e.scrollTop=f.bodyScrollTop;if(document.documentElement){e=document.documentElement;d=f.documentStyle;for(c in d){if(d.hasOwnProperty(c)){e.style[c]=d[c]}}e.scrollLeft=f.docScrollLeft;e.scrollTop=f.docScrollTop}a.FullScreen.bChanging=false;a.FullScreen.oFake=b;a.FullScreen.callHandlers();a.removeEvent(window,"keydown",a.FullScreen._keyDown);return true};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();a.FullScreen._nIDChangeEvent++;if(typeof(e)==="function"){if(!e._FSIFullScreenEventID){a.FullScreen._eventHandlers[a.FullScreen._nIDChangeEvent]=e;e._FSIFullScreenEventID=a.FullScreen._nIDChangeEvent}a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.callHandlers=function(){var c={type:"fullscreenchange",FSI_fake:true};for(var e in a.FullScreen._eventHandlers){if(a.FullScreen._eventHandlers.hasOwnProperty(e)){var d=a.FullScreen._eventHandlers[e];d(c)}}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)==="function"){if(e._FSIFullScreenEventID&&a.FullScreen._eventHandlers[e._FSIFullScreenEventID]){delete a.FullScreen._eventHandlers[e._FSIFullScreenEventID]}a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!==b&&c!==null)};a.FullScreen.getElement=function(){a.FullScreen.__init();var c;if(a.FullScreen.bUseFakeFullScreen){if(a.FullScreen.oFake){c=a.FullScreen.oFake.el}}else{c=document[a.FullScreen.fullscreenElement]}return c}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!==b){return}a.Easing={easeLinear:function(f,g,e,h){return h*(f/g)+e},easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f===0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f===g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f===0){return e}if(f===g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j/2)===2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.BrowserSupports.cssTouchAction()){for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,"")}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=this.handleDownEvent=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.IMGLoadingEngine!==b){return}a.IMGLoadingEngine=function(q,h){var p=this;var n=0;var w=0;var l=(typeof(h)==="function")?h:a.fnDoNothing;var j={};var c=1;var s;var g,d;var v;this.destroy=function(){e();p.abortAll();c=1;u()};this.getCountLoading=function(){return n};this.load=function(x,z,B,y,C){var A=(!v||v[B]===b);if(typeof(C)!=="object"){C={}}if(typeof(x)!=="object"){return C}if(typeof(B)!=="string"||B.length<1){B="default"}if(j[B]===b){j[B]={__count:0}}j[B][c]=x;j[B].__count++;n++;if(A){if(w===0){m(1)}w++}a.addEvent(x,"load",r);a.addEvent(x,"error",f);x.FSIIMGLoadingEngineData=C;C.uid=c;C.url=z;C.strPurpose=B;C.bLoading=true;C.bVisual=A;if(typeof(y)==="function"){C.fnLoad=y}a.utils.loadImageCors(x,z);c++};this.setNotVisualPurposes=function(x){if(typeof(x)&&x!==null&&typeof(x.concat)==="function"){if(x.length>0){v={};for(var y=0;y<x.length;y++){v[x[y]]=true}}else{v=b}}};var m=function(x){if(!l||x===g){return}g=x;e();s=setTimeout(i,50)};var i=function(){if(g===d){return}d=g;e();l.call(q,d)};var e=function(){if(s!==b){clearTimeout(s);s=b}};var u=this.reset=function(){if(n>0){for(var z in j){if(j.hasOwnProperty(z)){var y=z[j];for(var x in y){if(y.hasOwnProperty(x)){t(y[x])}}}}}n=w=0;j={}};var k=function(x){return(typeof(x)==="object"&&typeof(x.FSIIMGLoadingEngineData)==="object")};var t=function(x){if(!k(x)){return false}var y=x.FSIIMGLoadingEngineData;if(!y.bLoaded){y.bAborted=true}n--;if(x.FSIIMGLoadingEngineData.bVisual){w--;if(w===0){m(0)}}if(j[y.strPurpose]!==b){if(j[y.strPurpose][y.uid]===b){a.console.error("IMGLoadingEngine: failed to remove item with purpose '"+y.strPurpose+" and uid "+y.uid)}else{j[y.strPurpose][y.uid]=b;delete j[y.strPurpose][y.uid];delete x.FSIIMGLoadingEngineData}j[y.strPurpose].__count--;if(j[y.strPurpose].__count===0){delete j[y.strPurpose]}}return true};this.abortAll=function(){if(n>0){for(var z in j){if(j.hasOwnProperty(z)){var y=j[z];for(var x in y){if(y.hasOwnProperty(x)){o(y[x]);if(!y[x]){break}}}}}}};var o=this.abortItem=function(x){if(!k(x)){return false}if(x.FSIIMGLoadingEngineData.bAborted){return true}x.FSIIMGLoadingEngineData.bAborted=true;if(x.FSIIMGLoadingEngineData.bLoaded){t(x)}return true};this.abortPurpose=function(y){if(n<1){return false}if(typeof(j[y])!=="object"||j[y].__count<1){return false}for(var x in j[y]){if(j[y].hasOwnProperty(x)){o(j[y][x]);if(!j[y]){break}}}return true};var f=function(x){var y=this.FSIIMGLoadingEngineData;y.bError=true;r.apply(this,[x])};var r=function(x){var y=this;a.removeEvent(y,"load",r);a.removeEvent(y,"error",f);var z=y.FSIIMGLoadingEngineData;z.bLoading=false;z.bLoaded=true;if(!z.bError&&!z.bAborted){z.bSuccess=true}t(y);if(!z.bAborted&&z.fnLoad){z.fnLoad.apply(y,[x,z])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!==b){return}a.LoaderCSSSkin=function(){var e=this;var i=0;var g={};var c=0;var d=new a.CORSLoader();var h=function(m,l,u,k,s){var r=this;var t;var A=[];var n;var x=0;var q=false;var p=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return l.getSkinName()};this.callReady=function(C,D,F,E){if(this.bReleased){return}if(E){p=true}n=arguments;q=true;o()};var o=function(){if(!q||x>0){return}if(p){t=setTimeout(y,1)}else{y()}};var y=function(){j();u.apply(k,n)};var j=function(){if(t!==b){clearTimeout(t);t=b}};this.remove=function(){j();if(r.bReleased){return}l.removeWaiter(r.uniqueID);for(var C=0;C<A.length;C++){A[C].remove()}this.bReleased=true};var B=function(C,D,F,E){if(E){p=true}x--;o()};if(s&&typeof(s)=="object"&&s.length>0){for(var v=0;v<s.length;v++){var w=s[v];x++;var z=a.utils.loadSkinCSS(w.file,r,B,w.nPriority);A.push(z)}}};var f=function(j,v){var s=false;var k=0;var u={};var p=false;var q=false;var r;var o;var l;var n;l=j.match(/(.*)\/[^/]*$/);l=l[1]+"/";l=l.replace(/\/resources\/$/,"/");o=j.replace(/\.[^/]*$/,"");o=o.match(/([^/]*)$/);o=o[1].toLowerCase();this.removeWaiter=function(w){if(u[w]===b){return}delete u[w];k--};this.addWaiter=function(w){if(w.uniqueID===b||w.bReleased){return}if(p){w.callReady(q,n,"ALREADY LOADED",false)}else{if(u[w.uniqueID]===b){u[w.uniqueID]=w;k++;if(!s){t()}}}};this.getSkinName=function(){return o};var m=function(G,z,H,B){var E=false;if(B>299||typeof(z)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+B+"): "+j)}else{E=true;z=z.replace(/\[fsi-skin-path]/g,l);r=document.createElement("style");r.setAttribute("type","text/css");r.setAttribute("data-generated-by","FSI");r.setAttribute("data-fsi-skin",o);r.setAttribute("data-fsi-priority",v);r.appendChild(document.createTextNode(z));var D=document.head;if(!D){D=document.getElementsByTagName("head");if(D&&D.length>0){D=D[0]}}if(D&&D.firstChild){try{var y;var I=D.getElementsByTagName("style");for(var A=0;A<I.length;A++){var F=I[A];var x=parseInt(F.getAttribute("data-fsi-priority"));if(isNaN(x)||x>v){y=F;break}}if(y){D.insertBefore(r,y)}else{D.appendChild(r)}}catch(C){D.appendChild(r)}}else{D.appendChild(r)}n=r.sheet;q=E}p=true;for(var w in u){if(u.hasOwnProperty(w)){u[w].callReady(q,n,"onLoaded",true)}}u={};k=0};var t=function(){s=true;if(typeof(j)!="string"||j.length<0){return false}d.load(j,m,"text/css");return true}};this.load=function(o,p,l,q,k){if(q===b){q=100}var n=false;if(a.versionInternetExplorer<9){n=true}if(n){a.console.error("Unable to load skin: unsupported browser version.");if(l){l.call(p,false)}return false}if(!a.getViewerLocation()||typeof(o)!="string"||o.length<1){a.console.error("Unable to load skin:");if(!a.getViewerLocation()){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+o)}if(l){l.call(p,false)}return false}var j=o;if(j.indexOf("http")!==0){j=a.getViewerLocation()+"/skins/"+j}if(!j.match(/\.css$/)){j+=".css"}var r;if(g[j]===b){i++;r=g[j]=new f(j,q)}else{r=g[j]}var m=new h(j,r,l,p,k);r.addWaiter(m);return m}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!==b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n===b){n=window}if(typeof(j)!="function"){return false}if(k===b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!==b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded===true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i===b){return}if(i.oListeners[j]!==b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type==="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){if(j.oListeners.hasOwnProperty(k)){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!==b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.utils.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright===b){n="<br/><br/>&copy; 2020 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!==c){if(q){j()}else{i()}}};var m=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){g=q;k(q);p=true}else{p=false}return p};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){if(!f){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l===20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l===40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l===50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!==b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!==b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!==b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!==d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!==b){return}w=setTimeout(K,N);K()};var K=function(){if(w!==b){clearTimeout(w);w=b}var e=false;var U=L();if(C!==U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!==b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!==b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u===b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!==b){if(U===b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length===0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIMouseWheel")){return}a.utils.registerCustomEvent("FSIMouseWheel",function(){var c=this;var f=100000;var g;a.utils.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(h){h.callback=function(i){d(h,i)};a.addEvent(h.element,"mousewheel",h.callback);a.addEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerRemove=function(h){a.removeEvent(h.element,"mousewheel",h.callback);a.removeEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerCountChange=function(h){if(h<1){if(g!==b){clearInterval(g);g=b}}};this.setListenerProps=function(k,i,j){if(typeof(i)!=="string"){return false}var h=c.getListenerObjectByID(k);if(!h){return false}switch(i){case"acceleration":if(j){h.bAccelerate=true;h.acceleration=j;h._accelerate=1;if(h._accelerateMax===b){h._accelerateMax=10}}break;case"accelerationMax":h._accelerateMax=j;break}};var e=function(){var j=c.getListenersArray();var k=true;for(var l=0;l<j.length;l++){var h=j[l];if(h.bAccelerate&&h._accelerate>1){h._accelerate/=1.5*h.acceleration;if(h._accelerate>1.5){k=false}else{k=true;h._accelerate=1}}}if(k){clearInterval(g);g=b}};var d=function(h,i){var k=0;if(i.detail){k=i.detail}else{if(i.wheelDelta){k=-i.wheelDelta}}if(k!==0){i.FSI_normalized_delta=(k>0)?-1:1;f=Math.min(f,Math.abs(k))}else{i.FSI_normalized_delta=0}if(h.bAccelerate){if(g===b){g=setInterval(e,200)}h._accelerate*=h.acceleration;h._accelerate=Math.min(h._accelerateMax,h._accelerate);k=Math.round(h._accelerate*k)}else{h._accelerate=1}i.FSI_delta=-k;i.FSI_weighted_delta=i.FSI_delta/f;i.FSI_normalized_accelerated_delta=(k>0)?-h._accelerate:h._accelerate;var j=c.fireEvent(h,i);if(j===false){h._accelerate=1}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewportSize")){return}a.utils.registerCustomEvent("FSIViewportSizeChanged",function(){var d=this;var i=false;var c;a.utils.CustomEventListener.prototype.constructor.call(d,"FSIViewportSizeChanged");d._strClassName="$FSI.CustomEventListenerViewportSize";var h=function(){var j;var l=a.getViewportSize();var k=l.width+"x"+l.height;if(c!==k){c=k;e(l.width,l.height);j=true}else{j=false}return j};var g=function(){if(i){return}i=true;c=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){a.addEvent(window.visualViewport,"resize",h)}else{a.addEvent(window,"resize",h)}};var f=function(){if(!i){return}i=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",h)}else{a.removeEvent(window,"resize",h)}};this.onDestroy=function(){f()};this._onListenerCountChange=function(j){var k=(j>0);if(k!==i){if(k){g()}else{f()}}};this.triggerEvent=function(m){var j=d.getEventListenerByID(m);if(!j){return}var k={};var l=a.getViewportSize();k.FSI_width=l.width;k.FSI_height=l.height;d.fireEvent(j,k)};this.triggerEvents=function(){var j=a.getViewportSize();e(j.width,j.height)};var e=function(l,j){var k={};k.FSI_width=l;k.FSI_height=j;d.fireEvents(k)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.NavigatorWindow!==b){return}a.NavigatorWindow=function(q,B,x,K){var i=this;var aj=q.iViewer;var u;var ae=0;var m;var p,D,J,s;var g;var F,r;var h,f;var v=false;var y=false;var N=q.getElementSpace();var O=q.getinPlaceZoom();var X=q.getDrawRatio();var t=aj.getSrcDim();var ah=q.getdrawRatioUnZoomed();var G=q.getdrawRatioUnResized();var Z=q.viewport;var I;var Y;var c={x:2,y:2};var d;var ai;var P=false;var ab;var R;var ag={};var H;var C=false;var A;var L;var w=true;var e=true;var o;var U;var ac;var ad=function(){U=a.utils.getNumberSeperators(q.iConfig);v=B.result.autoHideNav;m=[];ae=4;g=16;o=B.makeBool(B.cfg.autohidenaviftoosmall,true);var an=l(B.result.navWidth,Z.width,120);var au=l(B.result.navHeight,Z.height,120);var aq=Math.min(N.width-2*ae,an);var ar=Math.min(N.height-2*ae-20,au);aq=Math.max(60,aq);ar=Math.max(40,ar);var ap,al;ap=aq;al=ap/ah.imageWidth*ah.imageHeight;if(al>ar){al=ar;ap=al/ah.imageHeight*ah.imageWidth}p=Math.max(10,Math.round(ap));D=Math.max(10,Math.round(al));J=Math.round(p*q.devicePixelRatio);s=Math.round(D*q.devicePixelRatio);var at=p+2*ae;var ao=D+2*ae+g;F=at;r=ao;i.sprite=new a.Sprite(K,at,ao,500);a.addClass(i.sprite.element,"fsi-ui-nav-window");i.sprite.element.style.width=i.sprite.element.style.height="auto";if(x){d=x.navFrameBorderColor;ai=x.navFrameBackgroundColor}else{d="red";ai="rgba(255,255,255,0.5)"}i.canvasSprite=new a.Sprite(i.sprite.element,p,D,2,true,"inline","",q.devicePixelRatio);i.canvasSprite.element.style.clear="both";a.addClass(i.canvasSprite.element,"fsi-ui-nav-window-image");if(B.hasPlugin("zoommeter")){I=document.createElement("div");a.addClass(I,"fsi-ui-nav-window-zoom-text");i.sprite.element.appendChild(I);Y=document.createTextNode("100 %");I.appendChild(Y);var am=B.getPluginParameter("zoommeter","color");if(am){I.style.color="#"+am}ac=parseInt(B.getPluginParameter("zoommeter","decimals"));if(isNaN(ac)||ac<0){ac=1}P=B.getPluginParameter("zoommeter","srcrelative",false,true)}i.sprite.updateMargins();i.sprite.updateDimension();var ak={};ak.smoothing={enabled:true,factor:7,fEndDiff:0.03};A=new a.TouchHandler(i.canvasSprite.canvas,ak,T,aa,W);R=i.canvasSprite.ctx;M();n();if(v){af(false)}};this.destroy=function(){if(j!==b){j=clearTimeout(j)}if(A){A.destroy();A=b}a.removeChild(K,i.sprite.element)};this.enable=function(ak,al){A.enable(ak);if(i.sprite&&i.sprite.element){if(al){i.sprite.element.style.visibility="hidden"}else{i.sprite.element.style.visibility=""}}};var l=function(an,al,am){var ak=parseInt(an);if(typeof(an)=="string"&&an.indexOf("%")!==-1){ak=Math.max(0,Math.min(100,ak));ak=Math.round(ak*al/100)}else{ak=parseInt(an)}if(isNaN(ak)){ak=am}return ak};this.isDragging=function(){return y};var T=function(al,ao){q.onUserAction();q.stopAutoSpin();var am=a.getElementPosition(i.canvasSprite.element);h=-am.left;f=-am.top;var ak=ao.x+h;var an=ao.y+f;if(ak<0||an<0||ak>p||an>D){return false}y=true;q.stopDesktopAnimation();q.stopAfterTouch();z(ao,true);q.autoShowHideHotSpots(false);q.iCallbacks.run("onStartDragging",[true]);return true};var aa=function(ak,al){z(al,true)};var W=function(ak,al){q.onUserAction();y=false;z(al,false);q.onAfterinPlaceZoomChanged();q.autoShowHideHotSpots(true);q.iCallbacks.run("onStopDragging",[true])};var z=function(an,al){var ak=an.x+h-p/2;var am=an.y+f-D/2;O.panPos.left=L*-ak;O.panPos.top=L*-am;q.updateInPlaceZoom(al)};var Q=function(at,aB,au,az,av){var aq,ao,an,am,ar,aA,ay;aA=aB;ay=au;aB=Math.max(1,Math.round(aB/2));if(aB<az){aB=az}au=Math.max(1,Math.round(au/2));if(au<av){au=av}ao=am=document.createElement("canvas");am.setAttribute("crossorigin","anonymous");am.width=aB;am.height=au;ar=am.getContext("2d");ar.drawImage(at,0,0,aA,ay,0,0,aB,au);var al=document.createElement("canvas");al.setAttribute("crossorigin","anonymous");var ap=al.getContext("2d");var ak=false;while(aB>az||au>av){aq=ao;aA=aB;ay=au;if(ak){ao=am;an=ar;ak=false}else{ao=al;an=ap;ak=true}aB=Math.round(aB/2);if(aB<az){aB=az}au=Math.round(au/2);if(au<av){au=av}ao.width=aB;ao.height=au;an.drawImage(aq,0,0,aA,ay,0,0,aB,au)}var ax;try{ax=an.getImageData(0,0,aB,au);ab=E}catch(aw){ax=ao;ab=k}return ax};var E=function(al,ak,am){R.putImageData(al,ak,am)};var k=function(al,ak,am){R.drawImage(al,ak,am)};var M=function(){switch(c.x){case 2:i.sprite.element.style.left="auto";i.sprite.element.style.right=i.sprite.margin.right+"px";break;default:i.sprite.element.style.right="auto";i.sprite.element.style.left=i.sprite.margin.left+"px";break}switch(c.y){case 2:i.sprite.element.style.top="auto";i.sprite.element.style.bottom=i.sprite.margin.bottom+aj.getMenuHeight("navWindow")+"px";break;default:i.sprite.element.style.bottom="auto";i.sprite.element.style.top=i.sprite.margin.top+"px";break}};this.setContainerSize=function(ak,an,am){var al=i.sprite.element.style.display;i.sprite.element.style.display="block";i.sprite.updateDimension();X=an;ah=am;N=ak;i.sprite.element.style.display=al;n()};var S=function(ak,al){if(ak===b){ak=(!C&&w)}if(e===ak){return}e=ak;i.sprite.show(ak,al)};var n=function(){if(!o){return}C=(N.width<4*i.sprite.width()||N.height<4*i.sprite.height());S(b,false)};var af=this.autoShowHide=function(al){if(!v){return}var ak=(O.scale>1.05);if(w!==ak){w=ak;S(b,al)}};this.setPreviewImageSize=function(ak,al){if(ak===b){H=b}else{ag.width=ak;ag.height=al;H=ag}};var j;var V=function(){j=b;var ak;if(P){ak=u*G.imageWidth/t.width}else{ak=X.imageWidth/ah.imageWidth}Y.nodeValue=a.utils.makeNiceNumber(100*ak,ac,U)+" %"};this.update=function(aC,au){af(true);if(!i.sprite.isVisible()){return}L=X.imageWidth/p;var at=R;if(m[aC]===b){var ax=q.getPreviewImage(aC);var ay=(H)?H:ax;m[aC]=Q(ax,ay.width,ay.height,J,s)}at.lineWidth=0;var ap=0;var ao=0;if(I&&u!==au){u=au;if(j===b){j=setTimeout(V,50)}}ab(m[aC],ap,ao);var aB=O.scale;if(aB>1.05){var ar=J/G.imageWidth/aB;var am=ar*Z.width;var av=ar*Z.height;var az=J/X.imageWidth;var aq=(J-am)/2-O.panPos.left*az;var aA=(s-av)/2-O.panPos.top*az;var al=ap+aq;var ak=ao+aA;var an=ap;var aw=ao;if(am<4||av<4){al+=am/2;ak+=av/2;at.strokeStyle=d;at.strokeRect(al,ak-3,1,7);at.strokeRect(al-3,ak,7,1)}else{at.save();at.fillStyle=ai;at.beginPath();at.rect(an,aw,J,ak-aw);at.rect(an,ak,al-an,av);at.rect(al+am,ak,J-aq-am,av);at.rect(an,ak+av,J,s-aA-av);at.closePath();at.clip();at.fillRect(ap,ao,J,s);at.restore();at.save();at.strokeStyle=d;at.beginPath();at.rect(ap,ao,J,s);at.clip();at.strokeRect(al,ak,am,av);at.restore()}}};this.reverseImageSequence=function(){m.reverse();m.unshift(m.pop())};ad()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(k,s,A,J,r){var i=this;var M=this.myViewer=k.iViewer;var B=k.getElementSpace();var h;var x;var u=0;var D=[];var m=b;if(r===b){r={}}this.bEnabled=b;var C={};var n={};var L={};var g=0;var j=0;var z="fsi-ui-button-icon";var q;var E;var o=1;var y=[];var d;var v,K;var p=this.setInterface=function(){v=k.getDebug();K=k.getToolTip()};var G=function(){i.oInterface=k;var N=k.iConfig;E=N.makeBool(N.cfg.menubuttontooltips,true,true);p(k);i.btnID=0;i.sprite=new a.Sprite(A,B.width,g,450,b,b,"fsi-ui-menu-bar");i.sprite.element.style.width="100%";i.sprite.element.style.top="auto";i.sprite.element.style.left="0px";i.sprite.element.style.right="auto";i.sprite.element.style.lineHeight="100%";i.sprite.element.style.bottom="0px";i.sprite.element.style.visibility="hidden";i.iconClassNamesNormal=z;m=setTimeout(f,0)};this.getContainer=function(){return A};this.getSprite=function(){return i.sprite.element};this.groupButtons=function(N){var Q;var O=[];for(Q=0;Q<N.length;Q++){var P=i.getButtonByCMD(N[Q]);if(P&&P.elButton){O.push(P.elButton)}}if(O.length>0){var S=document.createElement("span");S.className="fsi-ui-button-group-container";var R=O[0].parentNode;R.replaceChild(S,O[0]);for(Q=0;Q<N.length;Q++){S.appendChild(O[Q])}y.push(S)}};var f=function(){if(i.sprite.element.offsetHeight!==0||u++>200){m=b;l()}else{m=setTimeout(f,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(N,O){F(N,O,true)};this.removeButtonCSSClass=function(N,O){F(N,O,false)};var F=function(P,Q,O){var N=n[P];if(N===b){return}if(O){a.addClass(N.elButton,Q)}else{a.removeClass(N.elButton,Q)}i.setExternalButtonState(P,N.getState(),N.elButton.className)};this.getExternalButtonID=function(){return o++};var l=function(){var O=i.sprite.getClientDim();g=Math.round(O.height);i.sprite.setSize("100%",g);i.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){h=document.createElement("div");a.addClass(h,"fsi-ui-logo");a.utils.setStyleAttr(h,"position:absolute;display:none");var N=document.createElement("img");N.className="fsi-ui-logo-image";N.style.backgroundImage="none";N.src=s.urlLogo;h.appendChild(N);a.addEvent(N,"load",w);i.sprite.element.appendChild(h);a.addEvent(h,"click",M.showAboutWindow)}a.addEvent(i.sprite.element,"mouseup",e);a.addEvent(i.sprite.element,"contextmenu",H);i.sprite.element.style.visibility="";J()};this.show=function(N){if(d===N){return}d=N;i.sprite.show(N,false)};this.getVisible=function(){return d};this.destroy=function(){t("onMenuDestroy");if(m!==b){clearTimeout(m);m=b}if(h){a.removeEvent(h,"click",M.showAboutWindow)}a.removeEvent(i.sprite.element,"mouseup",e);a.removeEvent(i.sprite.element,"contextmenu",H);i.removeButtons();i.removeDomElement()};this.removeDomElement=function(){if(i.sprite.element.parentNode){a.removeChild(i.sprite.element.parentNode,i.sprite.element);g=0}};var e=function(N){if(N.which&&N.which===3){j=new Date().getTime()}};var H=function(O){if(j){var N=new Date().getTime()-j;if(N<300){return}}O.preventDefault&&O.preventDefault()};this.getHeight=function(){return g};this.pressButton=function(O){var N=n[O];if(N!==b){N.onMouseDown()}};this.releaseButton=function(O){var N=n[O];if(N!==b){N.onMouseUp()}};var c=function(N,P){var Q=b;if(!N||!P){return Q}if(N.indexOf("_")!==-1){var O=N.split("_");switch(O[0]){case"MouseMode":Q="";if(P.Mode){Q+="<b>"+P.Mode+"</b>"}if(P["Mode"+O[1]]){Q+=" "+P["Mode"+O[1]]}break}}return Q};this.showButtonToolTip=function(O,P){var N;if(P){N=P.getAttribute("fsi-tool-tip");if(k.iConfig.makeBool(N,true)===false){return}}if(!N){N=O.getCMD()}if(typeof(r[N])==="string"){N=r[N]}i.showToolTip(N,P)};this.getButtonDomElement=function(O){var N=n[O];if(N){return N.elButton}};this.showToolTip=function(P,O,N,Q){if(!K||!E){return}K.show(P,O,N,Q,c)};this.hideToolTip=function(){if(!K||!E){return}K.hide()};this.setEnabled=function(N,O){if(i.bEnabled===N){return}i.bEnabled=N;if(O){return}if(N){a.removeClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[N])};this.getButtonEnabled=function(O){var N=n[O];if(N===b){return}return N.bEnabled};this.showButton=function(P,N){var O=n[P];if(O===b){return false}return O.show(N)};this.enableButton=function(P,N){var O=n[P];if(O===b){return false}return O.setEnabled(N)};this.getButtonPressed=function(O){var N=n[O];if(N===b){return false}return N.getPressed()};this.setButtonPressed=function(P,N){var O=n[P];if(O===b){return false}O.setPressed(N);return true};var I=function(O,P){var N;if(C[P]===b){N=C[P]={};N.arButtons=[]}else{N=C[P]}N.arButtons.push(O);O.oGroup=N;O.makeRadioButton()};this.removeButtons=function(){var N;i.unregisterExternalButtons();for(N=0;N<D.length;N++){D[N].destroy()}for(N=0;N<y.length;N++){if(y[N]&&y[N].parentNode){y[N].parentNode.removeChild(y[N])}}D=[];C={};n={}};this.unregisterExternalButtons=function(){for(var P in L){if(L.hasOwnProperty(P)){var N=L[P];for(var O=0;O<N.length;O++){N[O].destroy(true)}}}L={}};this.addButtons=function(Y,ac){i.removeButtons();var Q;var Z=g-6;var S,ad;var R,aa,T;var O="";if(typeof(ac)==="string"&&ac.length>0){O=" (sorted by parameter MenuButtonOrder)";var N=ac.split(",");var W={};for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){W[Y[aa].cmd.toLowerCase()]=aa}}var V=[];var ab={};for(aa=0;aa<N.length;aa++){T=a.trim(N[aa].toLowerCase());if(W[T]!==b){if(ab[T]===b){ab[T]=true;V.push(Y[W[T]])}}}for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){T=Y[aa].cmd.toLowerCase();if(!ab[T]){V.push(Y[aa])}}}Y=V}else{O=" (default)"}if(!x){x=new a.Sprite(i.sprite.element,B.width,g,2);a.utils.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ae;if(v.on){ae=[]}for(aa=0;aa<Y.length;aa++){Q=Y[aa];if(Q.cmd){if(v.on){ae.push(Q.cmd)}if(Q.width===b){S=Z}else{S=Q.width}if(Q.height===b){ad=Z}else{ad=Q.height}R=new a.MenuBarButton(i,x.element,Q,Q.bCheckButton);n[Q.cmd]=R;D.push(R);if(Q.groupID!==b){I(R,Q.groupID)}}if(typeof(Q.fnCreate)==="function"){Q.fnCreate.apply(Q.fnCreateInstance,[R,Q])}if(Q.enabled===false){i.enableButton(Q.cmd,false)}}if(v.on){v.log("Button sequence"+O+": "+ae.join(","))}w();var P=q.run("onRegisterExternalMenuButtons");if(P){i.registerExternalButtonsFromContainer(P)}var U=k.iConfig;if(typeof(U.cfg.externalbuttoncontainer)!=="undefined"){i.registerExternalButtonsFromContainer(U.cfg.externalbuttoncontainer)}t("onMenuReady",[i]);for(var X in C){if(C.hasOwnProperty(X)){C[X].arButtons[0].setPressed(true)}}};this.createHiddenButton=function(O,Q){if(n[O]!==b){return n[O]}var N={cmd:O,bCheckButton:Q};var P=new a.MenuBarButton(i,b,N,N.bCheckButton);P.bUserButton=true;n[N.cmd]=P;D.push(P);return P};this.setCallbacks=function(N){q=N};var t=this.callListeners=function(O,N){if(q){q.run(O,N)}};this.setContainerSize=function(N){var O=i.sprite.element.style.display;i.sprite.element.style.display="block";var P=a.getElementClientDim(i.sprite.element);g=P.height;if(P.width===0&&P.height===0){return}i.sprite.updateDimension();B=N;i.sprite.setSize("100%",g);i.sprite.element.style.display=O;w();if(d){i.sprite.show(true)}};var w=function(){if(!h){return}h.style.display="";if(h.firstChild!==b&&h.firstChild.offsetWidth>0&&x!==b){var N=(i.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(N-8<h.firstChild.offsetWidth){h.style.display="none"}}};this.setPressedExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setPressed(O)}}};this.enableExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setEnabled(O)}}};this.setExternalButtonState=function(Q,P,R){if(L[Q]!==b){var N=L[Q];for(var O=0;O<N.length;O++){N[O].setState(P,R)}}};this.removeExternalButton=function(P,Q){var N=L[P];if(N!==b){for(var O=0;O<N.length;O++){if(N[O].nExternalButtonID===Q){N.splice(O,1)}}}};M.getMenuButtonPresent=function(O){var N=i.getButtonByCMD(O);return(N!==b&&N.bUserButton!==true)};M.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Registering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.registerExternalButton(Q[O],R)}}}v.groupEnd()};M.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.unregisterExternalButton(Q[O],R)}}}v.groupEnd()};M.registerExternalMenuButton=this.registerExternalButton=function(N,Q){var O=Q;if(typeof(O)!=="string"||O.length<1){O="user_tool_tip_only"}if(typeof(N)==="string"){N=document.getElementById(N)}if(!N||N.style===b){return false}if(N.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+N.FSIExternalButton.getCMD()+"'.")}return false}var P=new a.MenuBarExternalButton(i,k,N,O);if(!P.init()){v.error("The dom element could not be registered as external button for command '"+O+"'.",N);P.destroy();return false}if(P.bUserButton){v.log("Registering external button for user command: "+O,N)}else{v.log("Registering external button for command: "+O,N)}N.FSIExternalButton=P;if(L[O]===b){L[O]=[]}L[O].push(P);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[N,Q,(P.bUserButton!==true)])}};M.unregisterExternalMenuButton=this.unregisterExternalButton=function(O){if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b||typeof(O.FSIExternalButton)!=="object"||typeof(O.FSIExternalButton.destroy)!=="function"){return false}var N=O.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+N.getCMD(),O)}O.FSIExternalButton.destroy();O.FSIExternalButton=b;return true};this.getButtonByCMD=function(N){return n[N]};G()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("data-fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("data-fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}if(i.cssClass){if(l.length>0){l+=" "}l+=i.cssClass}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(B&&B.parentNode){a.removeChild(B.parentNode,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){z("onMenuButtonMouseDown",D);if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PluginMeasure!==b){return}a.PluginMeasure=function(y,q){var p=this;this.name="measure";var J;var h;var l,aa,v;var k,Z,u;var m,x,i;var D;var ad=1;var W;var ae;var ac=0;var t;var O;var V=1;var G;var E=0;var L,K;var e=true;var P,C,Y,j;var w=q.getCallbacks();var I=a.utils.makeNiceNumber;var N;var d={};var T;var R=a.utils.getSVGNameSpaceURL();var ab=function(){var ai=function(al){var am=g(al);if(am){am=a.utils.getCSSColor(am)}return am};N=a.utils.getNumberSeperators(q.iConfig);T=g("showInAllMouseModes",false,true);O=g("showAngle",false,true);j=g("showText",true,true);W=parseFloat(g("imageWidth","100"));if(isNaN(W)){W=100}C=g("prefix","");P=g("suffix","mm");P=" "+P;Y=parseInt(g("decimals","1"));if(isNaN(Y)||Y<0){Y=1}t=q.getRootContainer();J=document.createElement("div");J.setAttribute("style","position:absolute;width:100%;height:100%;overflow:hidden;z-index:101;");J.className="fsi-plugin-measure";h=document.createElementNS(R,"svg");h.setAttribute("style","width:100%;height:100%");h.className.baseVal="fsi-plugin-measure";m=document.createElementNS(R,"g");i=m.cloneNode(false);l=document.createElementNS(R,"line");l.setAttribute("x1",0);l.setAttribute("x2",0);l.setAttribute("y1",-8);l.setAttribute("y2",8);l.setAttribute("class","stroke:rgb(255,0,0);stroke-width:2");l.className.baseVal="fsi-plugin-measure-start-line";i.appendChild(l);aa=l.cloneNode(false);aa.className.baseVal="fsi-plugin-measure-end-line";aa.setAttribute("x1","100");aa.setAttribute("x2","100");i.appendChild(aa);v=l.cloneNode(false);v.className.baseVal="fsi-plugin-measure-main-line";v.setAttribute("x1","0");v.setAttribute("x2","100");v.setAttribute("y1","0");v.setAttribute("y2","0");i.appendChild(v);i.className.baseVal="fsi-plugin-measure-group-back";m.appendChild(i);x=i.cloneNode(true);x.className.baseVal="fsi-plugin-measure-group-front";m.appendChild(x);k=x.childNodes[0];Z=x.childNodes[1];u=x.childNodes[2];h.appendChild(m);J.appendChild(h);if(j){var ag=g("textSize","");var ak=ai("BGColor");var ah=ai("TextColor");var af=ai("TextBorder");var aj=ai("lineColor");D=document.createElement("span");D.className="fsi-plugin-measure-label";J.appendChild(D);if(ag){D.style.fontSize=ag+"px"}if(ak){D.style.background=ak}if(ah){D.style.color=ah}if(af){D.style.borderColor=af}if(aj){k.style.stroke=Z.style.stroke=u.style.stroke=aj}}t.appendChild(J);q.addDrawListener("FSI.PluginMeasure",z);q.registerPointerHandlers(100,F,Q,c);y.addListener("onMouseModeChanged",r);y.addListener("onResize",U);y.addListener("onAfterReady",X);M(false);A()};var g=function(ag,ah,af){return q.iConfig.getPluginParameter("measure",ag,ah,af)};var A=function(af){var ag=q.getdrawRatioUnZoomed();if(!ag||!ag.imageWidth){return}d.imageWidth=ag.imageWidth;d.imageHeight=ag.imageHeight;d.imageX=ag.imageX;d.imageY=ag.imageY;ad=W/ag.imageWidth;if(!af){f(0)}w.run("onMeasureUpdateRatio",[ad,W,ag.imageWidth])};var X=function(){A();var af=g("initial");if(af&&af.length>0){af=a.trim(af);af=af.split(",");if(af.length===4){var ag={};ag.x=parseFloat(af[0])*d.imageWidth+d.imageX;ag.y=parseFloat(af[1])*d.imageHeight+d.imageY;H(ag);ag.x=parseFloat(af[2])*d.imageWidth+d.imageX;ag.y=parseFloat(af[3])*d.imageHeight+d.imageY;s(ag,false);M((T||y.getMouseMode()===100),true)}}};var U=function(af,ah,ai){if(!ai||ac===0){return}var ag=e;var ak=a.utils.cloneObject(d);A(true);var aj=d.imageWidth/ak.imageWidth;d.x1=(ak.x1-ak.imageX)*aj+d.imageX;d.y1=(ak.y1-ak.imageY)*aj+d.imageY;d.x2=(ak.x2-ak.imageX)*aj+d.imageX;d.y2=(ak.y2-ak.imageY)*aj+d.imageY;H({x:d.x1,y:d.y1});s({x:d.x2,y:d.y2},d.bShift);n();if(!ag){M(false)}};var r=function(ag){var af=T;if(ag===100){if(ac!==0){af=true}q.setCursor("crosshair")}M(af,true)};var M=function(af,ag){if(af===e){return}e=af;if(e){J.style.display=""}else{J.style.display="none"}w.run("onMeasureShow",[e]);if(ag&&e){B();n()}};var f=function(af){if(af===ac){return}aa.setAttribute("x1",af);aa.setAttribute("x2",af);Z.setAttribute("x1",af);Z.setAttribute("x2",af);v.setAttribute("x2",af);u.setAttribute("x2",af);if(ac!==af){M(af!==0);ac=af}B()};var B=function(){if(!e){return}var ah=ad*ac/V;var ag=C+I(ah,Y,N)+P;if(O){ag+=", "+I(E,Y,N)+"°"}var af=w.run("onMeasureChange",[ah,E,ag]);if(typeof(af)==="string"){ag=af}d.label=ag;if(j){D.innerText=ag;if(G){n()}}G=b};var H=function(af){d.x1=L=af.x;d.y1=K=af.y};var n=function(){if(!e){return}m.setAttribute("transform","translate("+L+" "+K+") rotate("+E+")");if(!j){return}var am=L;var al=K;var af=E%360;var ao=Math.floor(af/90);var an=D.offsetWidth;var ai=D.offsetHeight;var ak=16;switch(ao){case 0:case 1:am+=ak;al-=ak+ai;break;case 2:case 3:am+=ak;al+=ak;break}var aj=y.getMenuHeight();var ah=t.offsetWidth-an;var ag=t.offsetHeight-aj-ai;if(al>ag){al=ag;if(ao===3){am=L-an-ak}}else{if(al<0){al=0;if(ao===0){am=L-an-ak}}}if(am>ah){am=ah;if(al===0||al===ag){am=Math.max(0,am-an)}}if(am<0){am=0;if(al===0||al===ag){am=Math.min(ah,am+an)}}D.style.left=am+"px";D.style.top=al+"px"};var S=function(af){return{x:af.x-ae.left,y:af.y-ae.top}};var o=function(ah,aj,ag,ai){var af=ag-ah;var ak=ai-aj;if(ak===0){ak=1e-8}if(af===0){af=1e-8}return Math.atan(ak/af)+(-0.5*(ak/Math.abs(ak))-0.5*(ak/Math.abs(ak))*(af/Math.abs(af))+1)*Math.PI};var F=function(af,ah){ae=a.getElementPosition(t);H(S(ah));f(0);n();var ag=ad*ac/V;w.run("onMeasureStart",[ag,E,d.label])};var Q=function(af,ag){s(S(ag),af.shiftKey)};var c=function(){if(w.isset("onMeasureEnd")){var af=[];af.push((d.x1-d.imageX)/d.imageWidth);af.push((d.y1-d.imageY)/d.imageHeight);af.push((d.x2-d.imageX)/d.imageWidth);af.push((d.y2-d.imageY)/d.imageHeight);var ag=ad*ac/V;w.run("onMeasureEnd",[ag,E,d.label,af])}};var s=function(ak,aj){d.x2=ak.x;d.y2=ak.y;d.bShift=aj;var ag=o(L,K,ak.x,ak.y);E=ag*180/Math.PI;if(aj){E=45*Math.round(E/45)}var ai=ak.x-L;var ah=ak.y-K;var af=Math.sqrt(ai*ai+ah*ah);f(af);n()};this.destroy=function(){y.removeListener("onMouseModeChanged",r);y.removeListener("onResize",U);y.removeListener("onAfterReady",X);if(G){clearTimeout(G);G=b}q.unregisterPointerHandlers(100);q.removeDrawListener("FSI.PluginMeasure");t.removeChild(J)};var z=function(ah,ag,af){if(e){if(G===b&&V!==af.scale){G=setTimeout(B,25)}V=af.scale}};ab()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.Viewer!==b){return}a.utils.API.Viewer=function(d,e){var c=this;c.scriptMainFile="FSI.Viewer.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons===b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!==b){f[h]=true}}return f};c.oMenuCommands={Reset:1,ZoomOut:1,ZoomIn:1,MouseMode_0:1,MouseMode_1:1,MouseMode_2:1,MouseMode_100:1,MaxZoom:1,HotSpots:"Hotspots",ToggleAutoSpin:"autospin-button-toggle",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeImage:{a:"oParameters, strViewString",r:"bSuccess"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},dumpListeners:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getHotspotViewString:{a:"nHotspotID",r:"strViewString"},getImageIsTransparent:{r:"bTransparent"},getInFullScreenMode:{r:"bFullScreen"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getMenuHeight:{a:"strPurpose",r:"nHeight"},getMouseMode:{r:"nMouseMode"},getParameters:{r:"oParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getSpinFrames:{r:"nFrames"},getSrcDim:{r:"oDimension"},getVersion:{r:"strVersion"},getViewString:{r:"strViewString"},getVisibleImageRect:{r:"rcVisibleRect"},getVisibleImageRectParameter:{r:"strImageRectParameter"},getVisibleImageURL:{a:"width, height, strEffects, bMakeImageFitInto",r:"strURL"},getZoom:{r:"fZoomInPercent"},getZoomFloat:{r:"fZoomAsFloat"},gotoHotspot:{a:"FSIHotspotID, bAnimate, bZoom",r:"bSuccess"},gotoViewString:{a:"strView, bAnimated",r:"bSuccess"},hideMenuToolTip:{},init:{a:"elementID, oParameters, bDebug"},makeBoolean:{a:"value, bDefaultValue",r:"bResult"},pressMenuButton:{a:"strButtonID"},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},resetView:{},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},setMouseMode:{a:"nMode"},setZoom:{a:"fZoomPercent, bPreliminary, bAnimate"},showAboutWindow:{},showMenuButton:{a:"strButtonID, bShow"},showMenuToolTip:{a:"strTip, elSrc, x, y"},spinToDegree:{a:"fDegree"},spinToTarget:{a:"nTargetFrame, nStopSceneSet, nFrames"},start:{},startAutoSpin:{r:"bSuccess"},stopAutoSpin:{r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"},updateSize:{}};c.oProperties={};c.oCallbacks={on3DWorldChanged:{a:"o3DData"},onAfterReady:{},onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAnimationComplete:{},onAnimationStart:{},onChangeConfig:{a:"strCfgFileName, oParameters"},onChangeImage:{a:"oParameters, strView"},onClickDemoMode:{a:"url, targetFrame"},onConfigsReady:{a:"oConfigValues"},onDataComplete:{},onDestroy:{},onEnterDemoMode:{},onExitDemoMode:{},onFullScreen:{a:"bSet"},onHotspotEvent:{a:"strAction, nHotspotID, strHotspotAttributeID, strContent, event"},onInit:{a:"oParameters)"},onInit3D:{a:"oProjection)"},onInitFailed:{a:"strReason"},onInitMenu:{},onLanguageData:{a:"oLanguageItems"},onMeasureChange:{a:"fLength, fRotation, strLabel",r:"strModifiedLabel"},onMeasureEnd:{a:"fLength, fRotation, strLabel, arCoords"},onMeasureShow:{a:"bShow"},onMeasureStart:{a:"fLength, fRotation, strLabel"},onMeasureUpdateRatio:{a:"fLengthFactor, fImageRealWidth, fImageWidth"},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonMouseDown:{a:"strButtonID, evt"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onMouseModeChanged:{a:"nMouseMode"},onProgress:{a:"fPercent"},onReady:{},onRegisterExternalMenuButtons:{},onReset:{},onResize:{a:"nWidth, nHeight, bResizeDone, bFullscreen"},onSkinChanged:{a:"strCurrentSkinClass, strCurrentSkinClassBefore"},onStartDragging:{a:"bInNavWindow"},onStopDragging:{a:"bInNavWindow"},onViewChanged:{a:"strViewString"},onZoomChanged:{a:"fScale, fScaleMax, fPercent"},onZoomChanging:{a:"fScale, fScaleMax, fPercent, bPreliminary"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Viewer!==b){return}a.Viewer=function(gC,et){var g7={};var aG={strVersion:"2020",strBuild:"20.10.3324",strConfigSection:"Viewer",oTraceConfigParameters:et,bHasListeners:true};var cQ=new a.utils.ClassDef(this,"FSI Viewer",aG);cQ.oAPI=new a.utils.API.Viewer(this,g7);var bk=cQ.instance;a.utils.guessFSIViewerLocation("fsiviewer.js",3);var d0=a.utils.getViewerInstanceID();this.getInstanceID=g7.getInstanceID=function(){return d0};this.getInstanceName=function(){return cQ.strClassName+" ["+S+"]"};this.debugLog=function(){dF.log.apply(dF,arguments)};this.debugWarn=function(){dF.warn.apply(dF,arguments)};this.debugError=function(){dF.error.apply(dF,arguments)};this.debugEnabled=function(){return dF.on};var g9;var gn,dj,cf;var aw;var m;var dg;var eB;var h;var gL={};var Z;var dI;var D;var e8;var bH;var dt=false;var J;var dM=0;var fM=0;var aJ={};var dL,d1;var eN;var bW;var ch;var cM;var bQ,bc;var dN=false;var hm;var M;var a3;var by={};var fT={};var T,eY;var g4={};var aM;var gW;var aT;var aR;var e0=8;var hG=1;var aj;var d=false;var ho=false;var gi;var cl;var bC;var dc;var fg;var hv,c3;var ff;var bI=true;var gS=100;var cg=true;var eQ;var b5;var aH;var da;var hn;var dE;var eW;var s;var bx;var dX=false;var fB=new a.CroppedImage();var fA=new a.Rect();var eO=a.Easing.easeOutCubic;var I=a.Easing.easeOutCubic;var dV=a.Easing.easeOutCubic;var e3;var e4={width:0,height:0};var bT;var aa;var aC;var g8;var bF;var aZ={};var cP=10000;var hB=cP;var fe;var bA;var X;var dq;var a7={x:0,y:0,z:0};var hb;var g1;var ai;var bb=new a.Rect(0,0,-1,-1);var dT=new a.Rect(0,0,-1,-1);var fG=new a.Rect(0,0,-1,-1);var f0=new a.Rect(0,0,-1,-1);var ge=new a.Rect(0,0,-1,-1);var aS=new a.Rect(0,0,0,0);var gX=new a.Rect(0,0,0,0);var aF=false;var Y=true;var hx=!(a.isChrome);var ed=false;var bS=false;var bV=false;var db=true;var C;var fr=false;var hr;var dm=false;var gU=true;var hk=false;var ga=false;var fC;var cc=new a.Rect(0,0,0,0);var eI=0;var dv;var cW=0;var bJ=0;var ak=0;var a1;var ex=0;var en=0;var cE=0;var dK={x:0,y:0};var ad={};var bn={};var x={};var eK="auto";var eP;var fD=1;var aA;var bv;var gM=true;var a4={};var cU,cO,u;var fL=b;var f;var df;var hE=false;var eS=false;var d6=true;var ds=true;var gE=false;var cv=false;var fj=false;var fR;var ck;var hd;var bB=false;var gY;var eL;var bp;var fo={};var cB;var du;var gt;var cC;var gl;var d8;var eg,dY;var af;var ek;var ev;var dB;var hA;var e=[];var hi=[];var dO;var dU={};var cH={};var gx;var ei=false;var hz;var bL,dy;var dZ;var fi={};var S;var dP;var ac;var hp={};var ao;var bm=g7.viewport={};var dJ=a.utils.getSVGNameSpaceURL();var f4="1.1";var bE;var hj;var ay;var cp=1;var bl=1;var aN;var cr;var fh;var fF=0;var fd=1;var ax=2;var gm=fF;var gB;var i=false;var a9;var b4;var f8;var hs;var aP=false;var fY=false;var gD;var cd={};var H=false;var P;var gp;var gO;var n;var fJ;var c2={width:0,height:0};var ce=false;var aO=false;var eh;var cs="&limit=0,360";var e9;var ha=false;var g3,aU;var z;var gh={};var fE=false;var b8;var cx="&effects=Matte(FFFFFF)";var c;var av;var aD;var c8={};var bw=true;var gr;var c0;var f2;var dS;var bN=0;var cG=0;var bP={};var cX=false;var e7=true;var K;var fw={};var au=0;var a6={};var cY={};var gy;var el={};var dF=new a.EmptyDebugger();var hu=function(hH,o){if(o&&!dF.on&&hH.on){gx.stopPendingRequests();bk.destroy(true);bk.init(gy,el,true);bk.start();return true}dF=hH;if(cM){cM.setDebug(dF)}if(dF.on){dF.setPrefix(bk.getInstanceName())}};var gs=g7;gs.iViewer=bk;gs.getDebug=function(){return dF};gs.getToolTip=function(){return f2};gs.getElementSpace=function(){return ao};gs.getDrawRatio=function(){return ad};gs.getdrawRatioUnZoomed=function(){return bn};gs.getdrawRatioUnResized=function(){return x};gs.getinPlaceZoom=function(){return cd};gs.getRootContainer=function(){return g9};gs.getParentElement=function(){return aw};gs.getCallbacks=function(){return cM};gs.getIsFullScreen=function(){return ei};gs.getImageArray=function(){return hi};gs.getCurrentSkin=function(){return a4};this.init=function(hH,hK,o){if(gE){bk.destroy()}gy=hH;if(typeof(hH)==="object"){if(typeof(hH.id)==="string"){S=hH.id}}else{if(typeof(hH)==="string"){S=hH}}if(!S){S="fsi.viewer #"+d0}if(bk._fsi_parameters){hK=bk._fsi_parameters;delete bk._fsi_parameters;bk._fsi_parameters=b}if(a.isMobileDevice){gB=5000000}else{gB=8000000}aT=new a.IMGLoadingEngine(bk,fb);var hI;if(typeof(hH)=="object"&&hH.tagName!==b){hI=hH}else{hI=document.getElementById(hH)}if(typeof(hK)=="object"&&typeof(window[hK.oninit])=="function"){window[hK.oninit](bk,S,hK)}gl=el=(hK&&typeof(hK)=="object")?a.utils.cloneParameters(hK):{};gJ();var hJ=el;if(o){hJ=a.utils.cloneObject(el);hJ.debug=true}gx.init(hJ);if(dF.on){dF.log(bk.getVersion())}B();if(!hI){dF.error("A DOM element with the id '"+hH+"' could not be found. Aborting.");return}bE="1.5px";if(a.isSmallMobileDevice){dF.log("Small mobile Device detected.");ce="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";bE="4px"}else{if(a.isMobileDevice){dF.log("Mobile Device detected.");ce="fsi-ui-hotspot-mobile"}}if(hI.firstChild){hI.innerHTML=""}aw=hI;if(aw.tagName.toLowerCase()!=="fsi-viewer"){a.addClass(aw,"fsi-viewer")}aw.setAttribute("data-fsi-id",S);fh=(a.isMobileDevice)?0.2:0.15;if(!g9){g9=document.createElement("div");g9.className="fsi-root fsi-viewer-root";a.utils.setStyleAttr(g9,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");hI.appendChild(g9)}am();dD(true);if(dF.on){dF.log("Container element: "+ao.width+" x "+ao.height+" ("+hI.nodeName+")")}gE=true;bx=a.utils.getCSSTransformStyleName();eQ=false};var gJ=function(){var o={};o.onConfigsReady=ea;o.onDebuggerChange=hu;gx=g7.iConfig=new a.Config(null,o,{strSection:cQ.strConfigSection});gx.setEffectsFilterArea();bk.loadFile=gx.loadFile;if(a3){gx.setAccessToken(a3)}if(!cM){cM=g7.iCallbacks=new a.Callbacks(bk,gx,b,ar);cM.watchListeners(cF,ey)}else{cM.setConfig(gx)}};var cF={onZoomChanged:true,onZoomChanging:true,onProgress:true};var ey=function(hH){var o=function(hK,hJ){var hI;if(hH[hK]===b){hI=hJ}else{hI=hH[hK]}return hI};cO=o("onZoomChanging",cO);u=o("onZoomChanged",u);cU=o("onProgress",cU)};var ar=function(hJ,o,hH){var hI=true;if(hJ==="onViewChanged"){hI=(bc!==b)}return hI};this.getInitDone=function(){return gE};g7.getViewportSize=function(){return bm};var am=function(){var o=a.getBoundingClientRect(g9);ao={width:o.width,height:o.height};var hH=(gL&&gL.minInstanceSize>1)?gL.minInstanceSize:60;if(ao.width<hH||ao.height-cG<hH){ao.visible=false;ao.width=hH;ao.height=hH+cG}else{ao.visible=true}bm.width=ao.width;bm.height=ao.height-cG};var b7=g7.setCursor=function(o){if(b8===o){return}if(hs){if(b8){a.removeClass(hs,"fsi-ui-cursor-"+b8)}if(o){a.addClass(hs,"fsi-ui-cursor-"+o)}}b8=o};var fS=function(hN,hM,hP,hL,o){var hJ=bm.width*aC.scale;var hH=bm.height*aC.scale;if(hN===b){hN=hJ/2}if(hM===b){hM=hH/2}var hI;if(hP!==b){hI=Math.max(1,Math.min(cd.maxScale,cd.scale+hP))}else{hI=cd.defaultZoom}var hO=hI/cd.scale;hN=hO*(cd.panPos.left-(hN-hJ/2));hM=hO*(cd.panPos.top-(hM-hH/2));var hK=(hL)?0:o;eZ(hN,hM,hI,hK)};var gF=function(o,hK,hI,hH){if(!cd.enabled){return}if(cd.panPos.left===0&&cd.panPos.top===0&&(hj<=1||(X&&cd.targetZoom===1))){return}var hJ=(hI)?0:hH;eZ(0,0,1,hJ)};var eT=function(o){if(aC.scale>1){o.scaleRect(1/aC.scale)}var hQ=o.width();var hL=o.height();if(hQ<1||hL<1){return}var hM=hQ/hL;var hK=bm.width/bm.height;if(hM>hK){hL=hQ*bm.height/bm.width;o.inflateRect(0,hL-o.height())}else{if(hM<hK){hQ=hL*bm.width/bm.height;o.inflateRect(hQ-o.width(),0)}}var hH=hj*bm.width/hQ;hH=Math.max(1,Math.min(cd.maxScale,hH));var hP=hH/hj;var hJ=o.left+o.width()/2;var hI=o.top+o.height()/2;var hO=(cd.panPos.left-hJ+bm.width/2)*hP;var hN=(cd.panPos.top-hI+bm.height/2)*hP;eZ(hO*aC.scale,hN*aC.scale,hH)};var eZ=function(o,hK,hJ,hH){hJ=Math.max(1,Math.min(cd.maxScale,hJ));eG();cd.pos=0;cd.frames=(hH!==b)?hH:28;if(cd.frames<1){cd.frames=1}cd.sourceZoom=cd.scale;cd.sourceX=cd.panPos.left;cd.sourceY=cd.panPos.top;if(o===b){o=cd.sourceX}if(hK===b){hK=cd.sourceY}var hI=hh(o,hK,hJ);cd.targetX=hI.x;cd.targetY=hI.y;cd.targetZoom=hJ;cd.dX=hI.x-cd.sourceX;cd.dY=hI.y-cd.sourceY;cd.dZoom=hJ-cd.sourceZoom;bq()};var A=g7.stopAfterTouch=function(){if(K){K.cancelAfterTouch()}};var aW=g7.autoShowHideHotSpots=function(o){if(ds===o){return}ds=o;if(!eS||!a.isMobileDevice){return}d6=o;gf(o);dR();if(o){hq()}};var bq=function(){if(X){return}dy=false;cd.lockPanAnimation=false;H=true;aW(false);X=true;cM.run("onAnimationStart");hq()};var eG=g7.stopDesktopAnimation=function(){if(X){aW(true);H=false;X=false;cd.pos=cd.frames=0;cd.targetZoom=b;cb();d3();f3();c5()}};var co=function(){if(X||hE){return}cM.run("onAnimationComplete");I=eO};var fH=function(){cd.pos++;gg(I(cd.pos,cd.frames,cd.sourceZoom,cd.dZoom));if(!cd.lockPanAnimation){cd.panPos.left=I(cd.pos,cd.frames,cd.sourceX,cd.dX);cd.panPos.top=I(cd.pos,cd.frames,cd.sourceY,cd.dY)}cb();if(cd.pos===cd.frames){eG();co();if(dy){fQ()}return false}return true};var e2=g7.onAfterinPlaceZoomChanged=function(){cb();d3();f3()};this.getMouseMode=function(){return eP};var fm=this.setMouseMode=function(o){if(K){K.cancel()}eK=o;switch(o){case"auto":if(z){o=(cd.bZoomedIn)?1:0}else{o=(cd.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(z){o=(cd.bZoomedIn)?1:0}else{o=2}break}cV(o)};var cV=function(o){eP=o;switch(eP){case 0:b7("zoom");break;case 1:b7("pan");break;case 2:if(a6.nSceneSets>1){b7("rotate3d")}else{b7("rotate")}break}cM.runPersistent("onMouseModeChanged",[eP]);if(c0){c0.setButtonPressed("MouseMode_"+eP,true)}};var f3=function(){if(!cd.enabled||eK!=="auto"){return}var o=(cd.scale>1);if(cd.bZoomedIn===o){return}cd.bZoomedIn=o;if(o){cd.bAutoMouseModePan=true;cV(1)}else{cd.bAutoMouseModePan=false;if(z){cV(0)}else{cV(2)}}};var hh=function(o,hN,hM){var hK={x:o,y:hN};var hL=Math.round(bn.imageWidth*hM);var hI=Math.round(bn.imageHeight*hM);var hJ=Math.max(0,(hL-ad.maxPanReferenceWidth)/2);var hH=Math.max(0,(hI-ad.maxPanReferenceHeight)/2);hK.x=Math.max(-hJ,Math.min(hJ,o));hK.y=Math.max(-hH,Math.min(hH,hN));return hK};this.getZoom=function(){if(cd.maxScale<=1){return 0}return(cd.scale-1)/(cd.maxScale-1)*100};this.getZoomFloat=function(){return cd.scale};this.setZoom=function(hJ,o,hH){if(isNaN(hJ)){return false}hJ=Math.max(0,Math.min(100,hJ));var hI=1+hJ*(cd.maxScale-1)/100;return eM(hI,o,hH)};var eM=function(hI,o,hH){if(!cv||!cd.enabled){return false}if(isNaN(hI)){return false}aI(true);eG();if(hH){eZ(b,b,hI);return}else{gg(hI)}cb(o);if(!o){d3();f3()}return true};this.gotoHotspot=function(hJ,hH,hI){if(!cv){return false}aI();if(hH!==false){hH=true}var o=bk.getHotspotViewString(hJ,hI);if(hI===false){o=o.split(",");o=o.splice(0,2);o=o.concat([0,0,1,1]);o=o.join(",")}if(o===false){return false}he(o,hH);return true};this.getHotspotViewString=function(hI,o,hH){if(!cv||eN[hI]===b){return false}return fs(eN[hI],hH,o)};var fs=function(hP,hY,hO){if(typeof(hP)!="object"){return false}if(hO===b){hO=hP.rotateOnFocus}if(hY===b){hY=hP.zoomOnFocus}var h7;var hQ;var o=(a6.nCurrent===b)?0:a6.nCurrent;var hV=o+1;var h0=Math.round(eI/(ex/bJ));var h5=1+h0;var hT=false;var hZ=false;var h8=false;var hM=en;var hU;var hN=false;if(hO){if(hP._focusSceneSet!==b){hN=true;if(hP._focusSceneSet!==false){hV=hP._focusSceneSet}}else{if(a6.nSceneSets===b||a6.nSceneSets<2||hP.perimeterAngleX===b){hP._focusSceneSet=false}else{var h6=cR();var h1=h6.angle;var hL=Math.abs(h6.stepAngle);hU=(hP.focusAngleX!==b)?hP.focusAngleX:hP.perimeterAngleX;if(typeof(hU)=="number"){var h9=hU-h1;if(!isNaN(h9)){h9=h9%360;if(h9<0){h9+=360}var hK=Math.round(h9/hL);hK=Math.max(0,Math.min(a6.nSceneSets,hK))+1;if(hK!==hV){hV=hK;if(hY){hZ=eI;h8=hT=true;f1(hV-1)}}}hP._focusSceneSet=false}else{hP._focusSceneSet=false}hP._focusSceneSet=hV}}if(hP._focusScene!==b){hN=true;if(hP._focusScene!==false){h5=hP._focusScene}}else{hU=(hP.focusAngleY!==b)?hP.focusAngleY:hP.perimeterAngleY;if(typeof(hU)=="number"){var hW=hz(Math.round(hU/360*bJ))+1;hZ=hz(Math.round(hU/360*ex));if(!isNaN(hW)){if(hY){if(hZ!==eI){hT=true}}hP._focusScene=h5=hW;hP._focusSpinPos=hZ}else{hP._focusScene=false}}else{hP._focusScene=false}}}var hS=(hO&&typeof(hP._focusScene)=="number"&&typeof(hP._focusSceneSet)=="number");if(hY&&hO&&hN&&!hS){if(hP._focusSceneSet!==false&&hP._focusSceneSet!==hV){hZ=eI;h8=hT=true;f1(hP._focusSceneSet-1)}if(hP._focusScene!==false&&hP._focusScene!==h0){hZ=hP._focusSpinPos;hT=true}}if(hT){cm(hZ);eD()}if(hY){if(hS&&hP._focusZoom!==b){hQ=hP._focusZoom}else{var hR=new THREE.Vector3();dU.camera.setViewOffset(bm.width,bm.height,0,0,bm.width,bm.height);if(hT){bo()}hR.setFromMatrixPosition(hP.object.matrixWorld);hR.project(dU.camera);var h4=0.5;var hH=0.5;var h3=bn.imageWidth/bm.width;var h2=bn.imageHeight/bm.height;var hJ=hR.x/h3*h4+h4;var hI=hH-hR.y/h2*hH;hk=true;var hX=new a.Rect(hJ,hI,hJ,hI);if(typeof(hP.focusRadius)=="number"&&hP.focusRadius>0){hX.inflateRect(hP.focusRadius,hP.focusRadius)}hQ=hX.toString();if(hS){hP._focusZoom=hQ}}}if(h8){f1(o)}if(hT){cm(hM);eD();hq()}h7=hV+","+h5;if(hQ!==b){h7+=","+hQ}return h7};var cD=this.getViewString=function(){if(!aD){return b}var o=[];var hJ=a6.nCurrent+1;var hI=1+Math.round(eI/(ex/bJ));if(isNaN(hI)){hI=1}var hH=fP();hH.round();o.push(hJ);o.push(hI);o.push(hH.toString());o.push(0);return o.join(",")};var fP=function(){var hM=fB.getImageRect();var o=hM.width()*cd.scale/cd.scaleToSourceImage;var hJ=hM.height()*cd.scale/cd.scaleToSourceImage;var hK=bm.width*aC.scale;var hN=bm.height*aC.scale;o=Math.max(o,hK);hJ=Math.max(hJ,hK);var hH=-cd.panPos.left+(o-hK)/2;var hI=-cd.panPos.top+(hJ-hN)/2;var hL=new a.Rect(hH,hI,hH+hK,hI+hN);hL.scaleRectXY(1/o,1/hJ);hL.limitToImageRect();return hL};this.getVisibleImageRect=function(){var hH=fP();if(fB.isCropped()){var o=fB.getFloatRect();hH=o.getPartialRect(hH)}hH.round();return hH};this.getVisibleImageRectParameter=function(){return gx.getImageRectParamFromRect(bk.getVisibleImageRect())};this.getVisibleImageURL=function(hO,hK,hM,hP){if(isNaN(hO)&&isNaN(hK)){hO=Math.round(Math.min(bm.width,ad.imageWidth))}var hI={};if(!isNaN(hO)){hI.width=Math.ceil(hO)}if(!isNaN(hK)){hI.height=Math.ceil(hK)}if(typeof(hM)==="string"&&hM.length>0){var hL=gx.getImageQueryParameters();hI.effects=hL.effects;gx.appendImageEffect(hI,"effects",hM)}var hH=bk.getVisibleImageRect();if(hP===true&&!isNaN(hO)&&!isNaN(hK)){var hJ=a.utils.fitImageIntoSpace(aD.width*hH.width(),aD.height*hH.height(),hO,hK,true);hI.width=hJ.width;delete hI.height;a.utils.extendRectToFill(hH,aD.width,aD.height,hO,hK,false,true);hH.round()}if(!hH.isDefaultImageRect()){hI.rect=gx.getImageRectParamFromRect(hH)}var hN=aK(hN);var o=hi[hN];return gx.getImageURL(o,hI)};var eC=function(hL){var hK={SceneSet:0,scene:0,frame:0};if(hL===b||typeof(hL)!=="string"||hL.length<3){return hK}var hO=gx.viewStringToArray(hL);if(hO.length<2){return hK}if(a6.nSceneSets<2){hK.SceneSet=0}else{hK.SceneSet=hO[0]-1;if(isNaN(hK.SceneSet)){hK.SceneSet=b}}hK.scene=hO[1];if(isNaN(hK.scene)){hK.scene=1}hK.scene=hK.scene%bJ-1;if(hK.scene<0){hK.scene+=bJ}hK.frame=hK.scene*ex/bJ;if(hO.length>5){var hS=hO[2];var hI=hO[3];var hQ=hO[4];var hJ=hO[5];var hH=hK.rc=new a.Rect(hS,hI,hQ,hJ);hH.normalizeRect();var hP=fB.getImageRect();var hW=cd.maxScale/cd.scaleToSourceImage;var hV=hW*hP.width()*hH.width();var hU=hW*hP.height()*hH.height();var hT=a.utils.fitImageIntoSpace(hV,hU,bm.width,bm.height,true,true);var hR=hT.width*aC.scale/hV;hK.zoom=cd.maxScale*hR;var hN=bn.imageWidth*hK.zoom;var hX=bn.imageHeight*hK.zoom;hH.scaleRectXY(hN,hX);hK.x=-(hH.left+hH.width()/2-hN/2);hK.y=-(hH.top+hH.height()/2-hX/2);var hM=hh(hK.x,hK.y,hK.zoom);hK.x=hM.x;hK.y=hM.y}return hK};var he=this.gotoViewString=function(hI,hJ){if(!cv){return false}aI();var o=(hJ)?30:0;var hH=eC(hI);if(hH.scene===b){return false}var hK=eC(cD());if(hH.SceneSet===hK.SceneSet&&hH.scene===hK.scene&&Math.abs(hH.x-hK.x)<1&&Math.abs(hH.y-hK.y)<1&&Math.abs(hH.zoom-hK.zoom)<0.000001){if(dy){fQ()}return true}if(hH.SceneSet!==hK.SceneSet||hH.scene!==hK.scene){bk.spinToTarget(hH.frame,hH.SceneSet,o)}if(cd.enabled&&hH.rc!==b){eZ(hH.x,hH.y,hH.zoom,o)}return true};this.changeImage=function(hJ,hK){cM.run("onChangeImage",[hJ,hK]);gx.makeObjectPropertiesLowerCase(hJ);if(!fj){fR=arguments;return false}av=cD();if(dF.on){a.console.log("")}dF.log("--- changeImage() called ---");gx.stopPendingRequests();var hM=false;if(hJ&&typeof(hJ)==="object"){if(hJ.fpxsrc!==b||hJ.imagepath!==b){hM=true}if(hJ.dir!==b){hM=true}}if(!hM){return bk.gotoViewString(hK,true)}if(hJ.imagepath!==b){hJ.fpxsrc=hJ.imagepath;hJ.imagepath=b;hJ.imagepath=b}hJ.fpxsrc=encodeURIComponent(hJ.fpxsrc);var o=["imagesrc","imagepath","imagesources","imagewidth","imageheight","imagetilesx","imagetilesy","imagetransparency","images3durl"];var hI=gx.cfgAliasNames;var hH=gx.cfg;for(var hL=0;hL<o.length;hL++){var hN=o[hL];delete hH[hN];if(hI[hN]){delete hH[hI[hN]]}}gx.setCfgValues(hJ);B();c=hK;bz();gx.dumpConfig();fW();return true};var gq=function(){var o=bT;if(hj<=1){fg=1;o=aN}else{var hI=hj*x.imageWidth;var hK=Math.round(aD.width/e4.width*hI);var hJ;for(var hH=0;hH<bC.length;hH++){if(bC[hH]>=hK){hJ=aa=bC[hH];break}}if(!hJ){if(bC.length>0){hJ=bC[bC.length-1]}if(hJ<=1.1*x.imageWidth){hJ=b}}if(hJ){o=Math.round(hJ*fB.getImageRect().width()/aD.width)}fg=o/aN}return o};var gg=function(o){o=Math.max(1,Math.min(cd.maxScale,o));cd.scale=o;hj=cd.scale*aC.scale;ay=Math.min(cd.maxScaleInitial,cp*cd.scale);dc=cd.scale*cp};var fZ=function(){var o=Math.min(cd.maxScaleInitial,cp);if(o*cd.scale>cd.maxScaleInitial){cd.scale=cd.maxScaleInitial/o}ay=Math.min(cd.maxScaleInitial,cp*cd.scale);return o};var ag=function(o){aC.scale=o;hj=aC.scale*cd.scale;ay=Math.min(cd.maxScaleInitial,cp*cd.scale);cd.scale=Math.max(1,ay/cp);dc=cp*cd.scale};var cb=g7.updateInPlaceZoom=function(hH){if(X){hH=true}var hI=false;if(hH){if(cd.nLastScalePreliminary!==hj){cd.nLastScalePreliminary=hj;hI=true}}else{if(cd.nLastScaleFinal!==hj){cd.nLastScaleFinal=hj;hI=true}}if(hI){if(!hH&&u){cM.runPersistent("onZoomChanged",[hj,cd.maxScaleInitial,bk.getZoom()])}if(cO){cM.runPersistent("onZoomChanging",[hj,cd.maxScaleInitial,bk.getZoom(),hH])}if(hH&&du&&hj-du.renderScale<-1){fz()}ad.imageWidth=hp.testWidth=Math.round(x.imageWidth*hj);ad.imageHeight=Math.round(x.imageHeight*hj);ad.imageX=Math.round(bn.imageX-(ad.imageWidth-bn.imageWidth)/2);ad.imageY=Math.round(bn.imageY-(ad.imageHeight-bn.imageHeight)/2);ad.maxImageOffsetX=Math.floor(Math.max(0,(ad.imageWidth-ad.maxPanReferenceWidth)/2-0.01));ad.maxImageOffsetY=Math.floor(Math.max(0,(ad.imageHeight-ad.maxPanReferenceHeight)/2-0.01));if(hd){ad.videoWidth=Math.round(x.videoWidth*hj);ad.videoHeight=Math.round(x.videoHeight*hj);ad.videoX=bn.videoX-(ad.videoWidth-bn.videoWidth)/2;ad.videoY=bn.videoY-(ad.videoHeight-bn.videoHeight)/2}if(!hH){var o;o=(cd.scale>1);cI("ZoomOut",o);if(gm<ax){cI("MouseMode_1",o)}o=(cd.scale<cd.maxScale);cI("ZoomIn",o);cI("MaxZoom",e4.width!==ad.imageWidth);bT=gq();cM.run("onAnimationComplete")}}if(!X){cd.panPos.left=Math.max(-ad.maxImageOffsetX,Math.min(ad.maxImageOffsetX,cd.panPos.left));cd.panPos.top=Math.max(-ad.maxImageOffsetY,Math.min(ad.maxImageOffsetY,cd.panPos.top))}if(!hH){cd.panPos.left=Math.floor(cd.panPos.left);cd.panPos.top=Math.floor(cd.panPos.top)}hk=true;dR();C=true;hq();if(!hH){an()}};var an=function(){if(!cM.isset("onViewChanged")){return}if(bQ!==b){clearTimeout(bQ)}bQ=setTimeout(bO,250)};var bO=function(){bQ=b;var o=cD();if(o===bc){return}bc=o;cM.runPersistent("onViewChanged",[o])};var d3=function(){if(!df&&!hE){ft()}};var cq=function(){var o=a.getElementClientPos(ff);bb.copyRect(cc);ge.copyRect(o);bb.interSectRectValidate(ge);bb.offsetRect(-ge.left,-ge.top);var hH=(bb.width()>0&&bb.height()>0);var hI=(hH!==aC.visible);aC.visible=hH;return hI};var cu=function(o){f0.copyRect(o);f0.offsetRect(-x.imageX,-x.imageY);if(bI&&f0.width()>0&&f0.height()>0){f0.inflateRect(gS/hj,gS/hj)}f0.scaleRect(fg)};var k=function(){var hH;var o;hH=(bb.left+bb.width()/2)-aC.widthUnScaled/2;if(aC.leftLast!==hH){aC.leftLast=hH;if(hH<0){hH=0}if(hH>aC.maxLeft){hH=aC.maxLeft}aC.left=hH}aC.drawOffsetX=aC.scale*-aC.left;o=(bb.top+bb.height()/2)-aC.heightUnScaled/2;if(aC.topLast!==o){aC.topLast=o;if(o<0){o=0}if(o>aC.maxTop){o=aC.maxTop}aC.top=o}aC.drawOffsetY=aC.scale*-aC.top;if(ed){dQ(aC.totalWidth,aC.totalHeight);hk=true;dR()}};var dQ=function(hI,hK){var o=gt.style.width;var hJ=gt.style.height;var hL=gt.width;var hH=gt.height;dU.renderer.setSize(hI,hK);gt.style.width=o;gt.style.height=hJ;gt.width=hL;gt.height=hH};var t=function(hH,hJ){if(fe){return}var hQ=cp;if(!i){l(ad.widthForRatio,ad.heightForRatio,true);hq();return}var hL=false;var hI=fZ();dc=cd.scale*cp;var hN=cq();if(hN){hH=true}else{if(!aC.visible){return}}if(!hH&&du){if((hN&&!aC.visible)||(aC.widthUnScaled<bb.width()||aC.heightUnScaled<bb.height()-cG)||(Math.abs(hI-aC.scale)>1)){if(hQ>1){hQ=1;hH=true}}}if(!hH){var hK=aC.left;var hU=aC.top;k();dq=(hK!==aC.left||hU!==aC.top);C=true;hq();return}var hO=a.getViewportSize();if(aC.bSizeAtMax&&(hO.width!==aC.dimViewport.width||hO.height!==aC.dimViewport.height)){hJ=true}if(hJ||aC.lastScale!==hI){aC.dimViewport=hO;aC.lastScale=hI;ag(hI);var hM=Math.ceil(bm.width*hI);var o=Math.ceil(bm.height*hI);var hT,hS;var hR=0;if(bI){hR=gS}aC.maxWidth=Math.round((hO.width*cp+hR)*hI/hQ);aC.maxHeight=Math.round((hO.height*cp+hR)*hI/hQ);aC.bSizeAtMax=false;if(hM>aC.maxWidth){aC.bSizeAtMax=true;hT=aC.maxWidth}else{hT=hM}if(o>aC.maxHeight){aC.bSizeAtMax=true;hS=aC.maxHeight}else{hS=o}aC.width=hT;aC.height=hS;aC.widthUnScaled=Math.ceil(hT/hI);aC.heightUnScaled=Math.ceil(hS/hI);aC.totalWidth=hM;aC.totalHeight=o;hL=(hJ||gt.width!==hT||gt.height!==hS)}aC.maxLeft=(aC.totalWidth-aC.width)/aC.scale;aC.maxTop=(aC.totalHeight-aC.height)/aC.scale;if(eQ){if(aC.scale!==1){var hP=1/aC.scale;if(cg){aC.strTransformScale=" scale3d("+hP+","+hP+","+hP+")"}else{aC.strTransformScale=" scale("+hP+","+hP+")"}}else{aC.strTransformScale=""}}else{aC.strTransformScale=""}k();if(hL){if(cg){g(gt,"translate3d("+aC.left+"px,"+aC.top+"px,0px)"+aC.strTransformScale)}else{g(gt,"translate("+aC.left+"px,"+aC.top+"px)"+aC.strTransformScale)}if(!eQ){gt.style.width=hT/hI+"px";gt.style.height=hS/hI+"px"}gt.width=hT;gt.height=hS;cC=gt.getContext("2d");hv=hM;c3=o;l(ad.widthForRatio,ad.heightForRatio,true);bT=gq();if(cd.enabled){c9();cb()}}else{if(cg){g(gt,"translate3d("+aC.left+"px,"+aC.top+"px,0px)"+aC.strTransformScale)}else{g(gt,"translate("+aC.left+"px,"+aC.top+"px)"+aC.strTransformScale)}if(!eQ){gt.style.width=gt.width/hI+"px";gt.style.height=gt.height/hI+"px"}}if(!ck){ft();C=true;hq()}else{cT()}};var g=function(o,hH){o.style[bx]=hH};this.showAboutWindow=function(){if(m){m.destroy();m=b;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=hD;o.strLongVersion=bk.getVersion();m=new a.AboutWindow(g9,o)};var hD=function(){m=b;return true};this.getParameters=function(){return a.utils.cloneParameters(el)};this.getConfigValue=function(hI){if(!gx){return}if(typeof(hI)!=="string"){return"error: type of argument must be string"}hI=a.trim(hI);if(hI.indexOf("_")!==-1){var o=hI.split("_");var hH=o.shift().toLowerCase();hI=o.join("_");return gx.getPluginParameter(hH,hI)}if(gx&&typeof(hI)==="string"){return gx.cfg[a.trim(hI.toLowerCase())]}};this.makeBoolean=function(hH,o){if(gx){return gx.makeBool(hH,o)}};this.getPluginParameter=function(hJ,hI,hH,o){if(gx){return gx.getPluginParameter(hJ,hI,hH,o)}};this.changeConfig=function(hH,hI,o){cM.run("onChangeConfig",[hH,hI]);if(dF.on){a.console.log("")}av=cD();cv=false;gA();if(o){el=gl={}}if(hI!=null&&typeof(hI)==="object"){el=a.utils.cloneParameters(gl);a.utils.mergeObjects(el,hI)}if(typeof(hH)==="string"){el.cfg=hH}gJ();dN=true;gA();bk.start()};var fp=function(o,hH){if(!o){return}if(!hH){if(o.FSI_prevDisplayState===b){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!==b){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=b}};var gf=function(o){if(!dt){o=false}fp(ac,o)};var be=this.onResize=function(o){if(eV()){return}if(!fe){fe=true;hw();bA=cD();if(K){K.cancel()}fp(hs,false);gf(false);if(f2){f2.hide()}}if(o.FSI_after_treshold!==b){b6()}dD(o.FSI_after_treshold)};var dD=function(o){var hH=a.getElementDimension(g9);cM.runPersistent("onResize",[hH.width,hH.height,(o!==b),ei])};this.updatePosition=function(){cq();C=true;hq()};this.updateSize=function(){dH();hb=setTimeout(hy,0)};var dH=function(){if(hb===b){return}clearTimeout(hb);hb=b};var hy=function(){dH();bk.updatePosition();b6()};var b6=function(hH){var hJ={};hJ.width=bm.width;hJ.height=bm.height;var o;if(gL.keepViewOnResize){if(!bA){bA=cD()}o=bA}bA=false;fe=false;am();fp(hs,true);gf(true);if(!hH&&hJ.width===bm.width&&hJ.height===bm.height){return}hw();eE();if(!gt||bm.width<1||bm.height<1){return}var hI=da;hv=bm.width;c3=bm.height;l(ad.widthForRatio,ad.heightForRatio);l(ad.widthForRatio,ad.heightForRatio,true);fO();C=true;if(ed){dQ(bm.width,bm.height);cn();dR();hk=true}eW=da=b;fz();aQ();if(gr){gr.setContainerSize(ao,ad,bn)}if(c0){c0.setContainerSize(ao)}fk();cb();e1(hI);if(o&&!fT.bEnabled){he(o)}t(true)};var gA=function(){da=eW=b;if(n){n.destroy();n=b}if(fi.nInterval!==b){clearInterval(fi.nInterval);fi.nInterval=b}dH();a.FullScreen.removeChangeEvents(window,cZ,a5);cM.run("onReset");if(c0){c0.unregisterExternalButtons()}if(bQ){clearTimeout(bQ);bQ=b}bc=b;cM.removeConfigListeners();hl();if(gY){gY.remove();gY=b}hw();aJ={};d9();aZ={};dF=new a.EmptyDebugger();B();if(gx){gx.reset();gx.init(el)}gL={}};g7.getConfigObject=function(){return gL};var g0=function(){if(e3&&b4){e3.lockImageSourceDimension(b4,false);e3.lockImage(b4,false);e3.removeImages(b4,false)}};var c9=function(){cd.nLastScalePreliminary=b;cd.nLastScaleFinal=b};var aQ=function(){c9();bT=aa=b;fC=b};var gT=function(){hp={}};var eE=function(){aC=g7.oDynamicCanvas={};aC.lastScale=b;ag(1);var o,hH;if(gt){o=gt.width;hH=gt.height}aC.leftLast=aC.topLast=b;aC.width=aC.widthUnScaled=aC.totalWidth=o;aC.height=aC.heightUnScaled=aC.totalHeight=hH;aC.left=aC.top=0;aC.drawOffsetX=aC.drawOffsetY=0};var B=function(){bc=b;dH();hw();aT.abortAll();dM=0;gU=true;bM();if(K){K.cancel()}aI();b0();eG();fz();aq();eu();cd.panPos={left:0,top:0};cd.maxScale=cd.maxScaleInitial=1;cd.scaleToSourceImage=1;cd.scale=1;cd.pos=cd.frames=0;cd.sourceX=cd.sourceY=0;cd.targetX=cd.targetY=0;cd.sourceZoom=cd.targetZoom=1;cd.dX=cd.dY=cd.dZoom=0;cd.lockPanAnimation=false;eE();gg(1);cp=1;gT();bF=b;e4={width:0,height:0};au++;aQ();d6=true;gf(false);aH=b;da=b;eW=b;hE=false;db=true;bV=false;if(c0){c0.setEnabled(false,true)}bB=false;c=b;cv=false;if(!i&&b4){a.removeEvent(b4,"load",dz)}c2={width:0,height:0};g0();hB=cP;f3();if(gp){clearTimeout(gp);gp=b}if(eh){clearTimeout(eh);eh=b}ew("image",true);gN();e=[];if(eS){if(bW){a.removeChild(ac,bW);bW=b}for(var o=0;o<gL.hotspots.points.length;o++){var hH=gL.hotspots.points[o];if(hH&&hH.tooltip){if(hH.interactive){if(!hH.tooltip.FSIEmpty){a.removeEvent(hH.tooltip,"mouseenter",fu);a.removeEvent(hH.tooltip,"mouseleave",fu)}if(hH.oSvg){a.addEvent(hH.oSvg.svg,"mouseenter",fu);a.addEvent(hH.oSvg.svg,"mouseleave",fu)}}a.removeChild(hH.tooltip.parentNode,hH.tooltip);a.removeChild(hH.marker.parentNode,hH.marker)}}}ck=false;eS=false;ex=b;bp="";dO=0;a9=b;hi=[];eu();if(cB){cB=b}fo={};ek=b};var eu=function(){if(dZ){fN(dZ);if(dZ.parentNode){a.removeChild(dZ.parentNode,dZ)}dZ=b}};var fN=function(hI){try{if(hI&&hI.FSIEvents){for(var hK in hI.FSIEvents){if(hI.FSIEvents.hasOwnProperty(hK)){var hH=hI.FSIEvents[hK];a.removeEvent(hI,hK,hH.fn,hH.phase)}}}}catch(hJ){}};this.addListener=function(hJ,hH,hI){var o=false;if(cM){o=cM.addListener(hJ,hH,hI)}return o};this.removeListener=function(hI,hH){var o=false;if(cM){o=cM.removeListener(hI,hH)}return o};g7.registerPointerHandlers=function(o,hI,hJ,hH){if(g4[o]){return}g4[o]={fnDown:hI,fnMove:hJ,fnUp:hH}};g7.unregisterPointerHandlers=function(o){if(g4[o]===b){return}delete g4[o]};var eA=function(o,hJ){g7.onUserAction();if(!cv||eP<0){return false}dl("mousedown",o);ch=(gh.interval!==b);aI();b0();if(cd.enabled){var hI=false;if(c8&&c8.timeStamp!==b&&(o.timeStamp-c8.timeStamp)<300){if(Math.abs(c8._posx-hJ.x)<50&&Math.abs(c8._posy-hJ.y)<50){hI=true}}if(!hI){var hH=(X)?cd.targetZoom:cd.scale;e7=(hH<=1)}c8=o;c8._posx=hJ.x;c8._posy=hJ.y;eG()}df=true;cM.run("onStartDragging",[false]);if(e3&&eP===2&&!z){e3.lockImageSourceDimension(b4,true);e3.lockImage(b4,true)}gt.lastOffsetX=hJ.x;gt.lastOffsetY=hJ.y;cE=en;dK.x=hJ.x;dK.y=hJ.y;switch(eP){case 0:if(cd.enabled){aS.clientOffset=a.getElementPosition(hs);aS.setRect(hJ.x,hJ.y,hJ.x,hJ.y);ga=true;hq()}break;case 2:fi.bEnabled=(hj>1);fi.bEnabled=true;fi.bSuspended=false;if(fi.bEnabled){fi.nTimeLastMove=fi.nTime=a.now();fi.nInterval=setInterval(fy,200)}dK.SceneSetStart=dK.SceneSetLast=a6.nCurrent;aS.clientOffset=a.getElementPosition(hs);b9("mouseDown");break}if(g4[eP]&&g4[eP].fnDown){g4[eP].fnDown.apply(bk,[o,hJ])}return true};var y=function(hN,hM){if(bl>1.2){hN.FSI_allowEventDefault=true;return}var hH=gt.lastOffsetX-hM.x;var o=gt.lastOffsetY-hM.y;switch(eP){case 0:if(cd.enabled){aS.setRect(aS.left,aS.top,hM.x,hM.y);hq()}break;case 2:if(fi.bSuspended){fi.nTimeLastMove=fi.nTime=a.now();fi.nInterval=setInterval(fy,200);b9("mouseDown");fi.bSuspended=false}if(a6.nSceneSets<2){if(Math.abs(o)>3*Math.abs(hH)){hN.FSI_allowEventDefault=true}}else{var hO=hM.y-dK.y;var hL=dK.SceneSetStart-Math.round(hO*a6.nSceneSets/bm.height);hL=ae(hL);if(hL!==dK.SceneSetLast){f1(hL);dK.SceneSetLast=hL}}hg(cE-(hM.x-hN.FSI_start_x)/fD);dO=(hH<0)?-1:1;fi.nTimeLastMove=fi.nTime;break;default:if(eP<100){var hI=false;if(cd.enabled){var hK=cd.panPos.left;var hJ=cd.panPos.top;cd.panPos.left-=hH*aC.scale;cd.panPos.top-=o*aC.scale;cb();hI=(hK!==cd.panPos.left||hJ!==cd.panPos.top);if(!hI){aW(true);hN.FSI_allowEventDefault=true}else{aW(false);hq()}}else{hN.FSI_allowEventDefault=true}}}gt.lastOffsetX=hM.x;gt.lastOffsetY=hM.y;if(g4[eP]&&g4[eP].fnMove){g4[eP].fnMove.apply(bk,[hN,hM])}};var ab=y;g7.enableAfterTouch=function(){if(K){K.enableAfterTouch.apply(this,arguments)}};g7.getCurrentPointerPos=function(){return K.getCurrentPos()};g7.blockMouseMove=function(hH,o){if(hH){ab=(o||a.fnDoNothing)}else{ab=y}K.setFnMove(ab)};var fy=function(){fi.nTime+=200;if(fi.nTime-fi.nTimeLastMove>400){cS()}};var cS=function(){if(fi.nInterval!==b){clearInterval(fi.nInterval);fi.nInterval=b}fi.bSuspended=true;gz()};var fX=function(hH,hL,hK){g7.onUserAction();if(!fw.bActive){aW(true)}var o=hH._FSI_Canceled;var hI=hH._FSI_Click;if(hI&&h){if(h.onClick(hH,hL)){hI=false}}cM.run("onStopDragging",[false]);df=false;ga=false;dl("mouseup",hH);if(o){if(eP===2){gz("pointer up - canceled")}return}switch(eP){case 0:if(cd.enabled){gH();if(!hI&&cd.maxScale>1){eT(gX)}hq()}break;case 1:if(gm===ax&&hj<=1){gF(0,0)}break;case 2:if(fi.nInterval){clearInterval(fi.nInterval);fi.nInterval=b}if(!hH._FSI_fromAfterTouch){eU(b,false)}else{var hJ=dr(en,false);eq(hJ,hJ,1,1);gz("pointer up")}break}f3();if(hI){b3(hH,hL,hK)}if(g4[eP]&&g4[eP].fnUp){g4[eP].fnUp.apply(bk,[hH,hL])}};var br=function(){return(eP===2||(eP===1&&hj>1))};var U=function(hL){if(eP===2){var hI=ex/bJ;var hH=hL.x-dK.x;var o=-hH/fD+cE;var hK=Math.round(o/hI)*hI;var hJ=-(hK-cE)*fD;hL.x=hJ+dK.x}return hL};var b3=function(hH,hK){if(ch&&gx.getPluginParameter("autospin","preventClickZoomWhileSpinning",false,true)){return}if(dl("click",hH)===true){return}if(eP===0||(gL.clickZoomInAllMouseModes&&eP<100)){if(!e7){gF(0,0)}else{if(cd.maxScale>1){var hI=a.getElementPosition(hs);var o=hK.x-hI.left;var hJ=hK.y-hI.top;fS(o*aC.scale,hJ*aC.scale)}}}};var dl=function(hI,o){var hJ=K.getInitialDownEvent();if(!hJ||!hJ.target||hJ.target===hs){return false}var hH=hJ.target;while(hH!==b&&hH!==g9&&hH.FSIHotspot===b){hH=hH.parentNode}if(hH&&hH.FSIHotspot){return f5(hI,hH,o)}return false};var gu=function(hI,hH,hL,hJ){for(var hK in hL){if(hL.hasOwnProperty(hK)){hH[hK]=hI.getFloatParameter(hJ+hK,hL[hK])}}};var es=function(hI,hH,hL,hJ){for(var hK in hL){if(hL.hasOwnProperty(hK)){hH[hK]=hI.getIntParameter(hJ+hK,hL[hK])}}};var dw=function(hJ,hI,hH,hK){for(var hL in hH){if(hH.hasOwnProperty(hL)){hI[hL]=hJ.getStringParameter(hK+hL,hH[hL])}}};var w=function(hI,hH,hK,hJ){for(var hL in hK){if(hK.hasOwnProperty(hL)){hH[hL]=hI.makeBool(hI.getStringParameter(hJ+hL),hK[hL])}}};var di=function(hH,o,hJ,hI){var hK;if(hJ&&hJ.length>0){if(typeof(o[hJ])!=="object"){o[hJ]={}}hI=hI[hJ];hK=o[hJ]}else{hK=o}if(hI.strings){dw(hH,hK,hI.strings,hJ)}if(hI.booleans){w(hH,hK,hI.booleans,hJ)}if(hI.floats){gu(hH,hK,hI.floats,hJ)}if(hI.integers){es(hH,hK,hI.integers,hJ)}};var L=function(){var o=function(hI){var hJ=gL[hI];hI=hI.toLowerCase();for(var hK in hJ){if(hJ.hasOwnProperty(hK)){var hH=hI+hK.toLowerCase();if(gx.cfg[hH]===b){gx.cfg[hH]=hJ[hK]}}}};o("camera");o("virtualSpace")};var bK={strings:{dir:"",easingZoom:"easeOutCubic",easingSpin:"easeOutCubic",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:b,fpxservertemplate:b,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"true",documentZoom:"auto",hideUI:"false",spinDirectionImage:"right",progressBarVAlign:"bottom",progressBarHAlign:"center",MenuButtonOrder:b,urlLoadingAnimation:"/skins/resources/loading.svg"},booleans:{menubar:true,keepViewOnResize:true,useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,forceDraw3D:false,forceHotSpots:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false,noSetLoop:false,noSceneLoop:false,initialViewPersistent:false,showPreviewWhileLoading:true,spinPreviewWhileLoading:true,showProgressbar:true,reverseSceneSets:false,autoDestroy:true,clickZoomInAllMouseModes:true},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,autoSpinInterval:0,tableDiameter:950,maxZoom:100,progressBarWidth:35,progressBarHeight:14},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right",sceneSet:0},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{strings:{position:"",targetPosition:"",armJointPosition:""},floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:b,heightTable:b,heightCamera:1000,targetHeightOffset:0,targetWidthOffset:0,shiftX:0,armLength:0,armAngleMeasureSetup:0,armAngleStart:0,armAngleEnd:0}},virtualSpace:{integers:{cubeSegments:4},strings:{position:""},floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationX:0,rotationXRange:180,rotationXSets:0,baseRotationY:0,rotationYRange:360,rotationYScenes:0,baseRotationZ:0,shiftX:0,shiftZ:0,shiftY:0}}};var cy=function(hH){if(!hH||typeof(hH)!=="object"){hH={}}hH.serverBase=gx.serverBase;di(gx,hH,"",bK);di(gx,hH,"camera",bK);di(gx,hH,"virtualSpace",bK);di(gx,hH,"video",bK);if(gL.enableHotspots){var o=gx.getUnrecognizedConfigNode("hotspots3d");dh(o)}cx="&effects=Matte("+encodeURIComponent(gL.imagemattecolor)+")"};g7.getHotSpots=function(){return gL.hotspots};g7.setHotspotCode=function(o){hp.arSpotsAtFrame=b;hp.hotSpotsAtThisFrame=b;hp.spinFrame=b;a6.bSetCameraPosition=false;ac.innerHTML="";di(gx,gL,"camera",bK);di(gx,gL,"virtualSpace",bK);Q();dh(o);hC();hk=true;dR();hq()};var dh=function(hJ){var hR={strings:{id:"",normalClass:"",hoverClass:"",activeClass:"",text:"",actionParameter:b,url:b,urlTarget:"_self",cssStyle:"",cssClass:"",icon:""},booleans:{interactive:false,rotateOnFocus:true,zoomOnFocus:true,focusOnClick:true},floats:{iconScaleX:1,iconScaleY:1,perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:b,perimeterAngleRange:30,perimeterAngleFadeOut:10,perimeterAngleX:b,perimeterAngleXRange:30,perimeterAngleXFadeOut:10,perimeterAngleY:b,perimeterAngleYRange:30,perimeterAngleYFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:b,perimeterTerminator:b,x:0,y:0,z:0,focusRadius:0.25,focusAngleX:b,focusAngleY:b}};ap={};var hL=[];var hK;var hP=new a.Config();var hI,hO,hQ;var hN,hH,hS;if(typeof(gx.cfg.hotspots)==="object"&&gx.cfg.hotspots.length>0&&typeof(gx.cfg.hotspots.join)==="function"){dF.log("Using HotSpots from JS parameters");gL.hotspots={};gL.hotspots.defaults={};gL.hotspots.points=new Array(gx.cfg.hotspots.length);hI=gx.cfg.hotspotsdefaults;if(hI===b){hI=gx.cfg.hotspotdefaults}if(hI!==b){hP.makeObjectPropertiesLowerCase(hI);hP.cfg=hI;hK={};di(hP,hK,"",hR);for(hH in hR){if(hR.hasOwnProperty(hH)){hO=hR[hH];for(hS in hO){if(hO.hasOwnProperty(hS)){if(hK[hS]!==b){hO[hS]=hK[hS]}}}}}hI=hK;hK={};for(hH in hI){if(hI.hasOwnProperty(hH)){if(hI[hH]!==b){hK[hH]=hI[hH]}}}gL.hotspots.defaults=hK}for(hN=0;hN<gx.cfg.hotspots.length;hN++){hQ=gx.cfg.hotspots[hN];hP.makeObjectPropertiesLowerCase(hQ);hP.cfg=hQ;hQ={};di(hP,hQ,"",hR);gL.hotspots.points[hN]=hQ}}else{if(hJ){hJ=hJ.firstChild;while(hJ){if(hJ.nodeType!==1){hJ=hJ.nextSibling;continue}var hM=hJ.nodeName.toLowerCase();switch(hM){case"hotspot":hL.push(hJ);break;case"defaults":hK=eJ(hP,hJ,hR);break}hJ=hJ.nextSibling}}if(hK!==b){for(hH in hR){if(hR.hasOwnProperty(hH)){hO=hR[hH];for(hS in hO){if(hO.hasOwnProperty(hS)){if(hK[hS]!==b){hO[hS]=hK[hS]}}}}}hI=hK;hK={};for(hH in hI){if(hI.hasOwnProperty(hH)){if(hI[hH]!==b){hK[hH]=hI[hH]}}}}for(hN=0;hN<hL.length;hN++){hL[hN]=eJ(hP,hL[hN],hR)}gL.hotspots={};gL.hotspots.points=hL;gL.hotspots.defaults=hK}if(gL.hotspots&&gL.hotspots.points){dF.log("HotSpots parsed: "+gL.hotspots.points.length);eS=(gL.hotspots.points.length>0)}else{eS=false}if(gL.forceHotSpots&&!eS){eS=true;gL.hotspots={};gL.hotspots.defaults={};gL.hotspots.points=[]}};var eJ=function(hH,hL,hK){var o=a.utils.attributes2parameters(hL);hH.makeObjectPropertiesLowerCase(o);hL=hL.firstChild;while(hL){if(hL.nodeType!==1){hL=hL.nextSibling;continue}var hJ=hH.getValueFromXMLNode(hL,"");o[hJ.name]=hJ.value;hL=hL.nextSibling}hH.cfg=o;var hI={};di(hH,hI,"",hK);if(gW&&hH.cfg.hse_id!==b){ap[hH.cfg.hse_id]=hI}return hI};var ec=function(){cy(gL);if(gx.cfg.hotspoteditor===true){gW=true}gx.result=gL;Q()};var gV=function(o,hQ){dF.log("Video Dimension: "+o+" x "+hQ+"px");var hM=fB.isCropped();var hN=false;var hH=fB.getCropMargins();var hK=aD.width;var hP=hK/o;var hO=hQ*hP;var hL=Math.round((aD.height-hO)/2);if(hL>hH.top){hN=true;hH.top=hL}if(hL>hH.bottom){hN=true;hH.bottom=hL}if(hN){dF.log("Cropping images to match video dimension ("+hL+"px)");fB.setCropValues(hH.left+"px",hH.top+"px",hH.right+"px",hH.bottom+"px");q()}if(hM){hH=fB.getCropMargins();hH.scaleRectInt(1/hP);hL=Math.round(hL/hP);fA.left=hH.left;fA.right=hH.right;fA.top=hH.top-hL;fA.bottom=hH.bottom-hL}else{fA.setRect(0,0,0,0)}bF=b;bX();var hI=o-fA.left-fA.right;var hJ=hQ-fA.top-fA.bottom;c2={width:o,height:hQ,croppedWidth:hI,croppedHeight:hJ};l(hI,hJ);d4();if(cC&&gL.pellets&&gL.pelletsOpacity>0){cA()}};var l=function(hQ,h5,hT){if(!gL||!gL.video||aD===b||!gL.video.widthCorrectionFactor){return}var hX,h0;var hR;var hP;var hS,h2,hZ,hK;if(!i){hZ=bm.width;hK=bm.height}else{hZ=hv;hK=c3}var h6=hQ/h5;var hO=hZ/hK;var hN,o;if(h6>hO){hN=hZ}else{o=hK}bX();hX=fB.getFloatRect();var hU=hX.getRange();var hW=a.getFSIServerImageDim(aD.width,aD.height,hN,o,hU,true);hS=hW.width;h2=hW.height;if(hS>e4.width||h2>e4.height){hS=e4.width;h2=e4.height}bT=Math.min(hB,Math.round(hS));hR=Math.round((hZ-hS)/2);hP=Math.round((hK-h2)/2);ad.widthForRatio=hQ;ad.heightForRatio=h5;ad.imageWidth=hS;ad.imageHeight=h2;ad.imageX=hR;ad.imageY=hP;if(aC.scale===1){ad.imageWidthAbsolute=ad.imageWidth;ad.imageHeightAbsolute=ad.imageHeight;ad.imageXAbsolute=(aC.drawOffsetX+ad.imageX-(ad.imageWidth*aC.scale-ad.imageWidth)/2)/aC.scale;ad.imageYAbsolute=(aC.drawOffsetY+ad.imageY-(ad.imageHeight*aC.scale-ad.imageHeight)/2)/aC.scale}ad.videoWidth=hS*gL.video.widthCorrectionFactor;ad.videoHeight=h2*gL.video.heightCorrectionFactor;ad.videoX=hR+hS*gL.video.xCorrectionFactor-(hS*gL.video.widthCorrectionFactor-hS)/2;ad.videoY=hP+h2*gL.video.yCorrectionFactor-(h2*gL.video.heightCorrectionFactor-h2)/2;if(!hT){aN=bT;eH(x)}eH(bn);if(!hT){hX=fB.getImageRect();var hY;if(hX.width()>0){hY=aD.width/hX.width()}else{hY=0}var hL=Math.ceil(hY*x.imageWidth);if(aD.__levelsCalculatedFor!==hL){aD.__levelsCalculatedFor=hL;dF.log("Calculating image levels for image base width: "+hL+" px");dF.log("Source image dimension: "+aD.width+" x "+aD.height);var hV=Math.ceil(1.1*hL);bC=[];if(hL>0){if(aD.levels&&aD.levels.length>0){var h4=[];for(h0=0;h0<aD.levels.length;h0++){var hJ=parseInt(aD.levels[h0].width);if(!isNaN(hJ)){if(hJ>hV){h4.push(hJ)}else{break}}}if(dF.on){dF.log("Matching server side image levels: "+h4.join(", "))}if(h4.length>0){h4.push(hL);var hI=h4[0];bC.push(hI);for(h0=1;h0<h4.length;h0++){var h1=h4[h0];var hM=hI/h1;while(hM>2.5){hI/=2;hM=hI/h1;if(hI>hV){bC.push(Math.round(hI))}}bC.push(h1);hI=h1}bC.pop();h4.pop();bC.reverse()}if(dF.on){var h3=(bC.length-h4.length);if(h3===0){dF.log("Using server side image levels only.")}else{dF.log("Using "+h3+" additional virtual image levels.")}}}else{dF.log("No image level information from server. Using virtual image levels.");var hH=aD.width;var h7=aD.height;if(hV>0){while(hH>hV&&h7>0){bC.push(hH);hH=Math.round(hH/2);h7=Math.round(h7/2)}}bC.reverse()}}if(dF.on){dF.log("Using image levels: "+bC.join(", "))}}}bs();switch(gm){case fF:ad.maxPanReferenceWidth=bm.width*aC.scale;ad.maxPanReferenceHeight=bm.height*aC.scale;break;case ax:ad.maxPanReferenceWidth=0;ad.maxPanReferenceHeight=0;break;default:ad.maxPanReferenceWidth=bn.imageWidth;ad.maxPanReferenceHeight=bn.imageHeight;break}};var eH=function(hH){for(var hI in ad){if(ad.hasOwnProperty(hI)){hH[hI]=ad[hI]}}};var az=function(){var o=gL.video.source;if(o&&o.indexOf("[static]")===0&&gL.serverBase!==b){var hH=gL.serverBase;hH=hH.split("/");hH.pop();hH=hH.join("/");o=o.replace(/\[static]\/*/,hH+"/static/")}return o};this.start=function(){dg=a.now();fM=0;er();if(c0&&!dN){c0.destroy();c0=b}if(!gE){return}eF()};var eF=function(){gL={};gx.loadConfigs()};var fK=function(){var o=dL;if(typeof(o)==="string"){o=document.getElementById(o);if(!o){o=aw}}return o};var em=function(){if(typeof(gx.cfg.fullscreenelement)!="undefined"){dL=gx.cfg.fullscreenelement}else{dL=aw}};var ea=function(){ec();am();em();if(cM.isset("onConfigsReady")){cM.runPersistent("onConfigsReady",[a.utils.cloneObject(gx.cfg)])}var hH=[];if(typeof(gx.cfg.invisibleloadingpurposes)==="string"){hH=gx.cfg.invisibleloadingpurposes.split(",")}aT.setNotVisualPurposes(hH);if(gx.hasPlugin("autospin")){var hL=gx.getPluginParameter("autospin","speed",4);if(hL!==b){hL=parseFloat(hL);if(!isNaN(hL)){gL.autoSpinSpeed=hL}}var o=gx.getPluginParameter("autospin","interval");if(o!==b){o=parseInt(o);if(!isNaN(o)){gL.autoSpinInterval=o}}}if(gx.hasPlugin("fullscreen")&&!gx.hasPlugin("resize")){gx.addPluginFromString("resize")}var hN=gL.enableZoom;i=(a.BrowserSupports.canvas());cd.enabled=false;s=false;if(hN&&a.BrowserSupports.canvas()){var hJ=""+gL.inPlaceZoom;switch(hJ.toLowerCase()){case"auto":cd.enabled=(!a.isMobileDevice);break;default:cd.enabled=gx.makeBool(hJ,true);break}hJ=""+gL.documentZoom;switch(hJ.toLowerCase()){case"auto":s=(a.isTouch);break;default:s=gx.makeBool(hJ,true);break}}d=false;hJ=""+gL.hideUI;hJ=hJ.toLowerCase();if((a.isMobileDevice&&hJ==="onmobiledevices")||(!cd.enabled&&hJ==="ifnoinplacezoom")||gx.makeBool(gL.hideUI)===true){d=true}bw=(!gL.noNav&&!d&&cd.enabled);ho=!gx.makeBool(gL.menubar,true);if(i){e3=b}else{e3=a._FSITouchZoomInstance}if(aU===b){aU=a.addCustomEvent(window,"FSIViewportSizeChanged",gk)}if(i&&gx.hasPlugin("resize")){if(!ha){var hI=g3=a.addCustomEvent(g9,"FSIElementDimension",be);a.setCustomEventListenerProperty(hI,"treshold",100);ha=true}}else{if(ha){a.removeCustomEvent(g9,"FSIElementDimension",be);g3=b;ha=false}}if(gL.noCanvas){i=false}var hM=ba;var hK=gx.cfg.customskinclass;if(M&&M.paramCustomSkinClass!==hK){M.destroy()}if(hK!==b){if(!M||M.paramCustomSkinClass!==hK){M=new a.CustomSkinClass(bk,hK,g7,hM)}}else{hM()}};var gk=function(o){fk()};var ba=function(hH){if(gx.makeBool(gL.urlLoadingAnimation,true)&&cf!==gL.urlLoadingAnimation){cf=gL.urlLoadingAnimation;var o=gx.getReloadPath(gx.locationFSIViewer,gL.urlLoadingAnimation);gx.loadFile(o,gw,"text/html; charset=utf-8")}else{v()}};var gw=function(o){var hH=o.responseText;if(gn){gn=b}if(typeof(hH)==="string"&&hH.length>0){gn=document.createElement("div");a.addClass(gn,"fsi-viewer-loading-animation");gn.innerHTML=hH}v()};var e5=function(){if(!gn||aR){return}dj=gn;if(dj){aR=true;g9.appendChild(dj)}};var hl=function(){if(aR&&dj&&dj.parentNode){a.removeChild(dj.parentNode,dj);dj=b}aR=false};var ef=function(){var o="/linkeditor/js/fsilinkeditor.js";var hH="fsiviewer.js";var hI=a.utils.getScriptPath(hH,2);dF.log("Loading LLoading language fileinkEditor: "+hI+o);a.loadJavascript(hI+o,d0,bk,gI,hI)};var gI=function(o,hI,hH){h=new a.LinkEditor(bk,g7,g9,{});h.init(d0,hH,v)};var v=function(){if(gx.hasPlugin("linkeditor")&&!h){ef();return}e5();var hH=gL.skin;if(hm!==hH){dN=false;hm=hH}dF.log("Loading skin: "+hH+".css");if(gY){gY.remove();gY=b}if(!dN){var hI=a4.className;a4.name=hH.replace(/\.css\s*$/i,"");a4.className="fsi-skin-"+a4.name;g9.className="fsi-root fsi-viewer-root "+a4.className;var o=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-viewer-core.css",nPriority:5}];gY=a.utils.loadSkinCSS(hH,bk,de,10,o);if(hI!==a4.className){cM.runPersistent("onSkinChanged",[a4.className,hI])}}else{de(dN)}};this.getSkinClassName=function(){return a4.className};var gj=function(){if(fT.bEnabled){return}fT.bEnabled=true;bA=b;if(typeof(gL.initialview)==="string"&&gL.initialview.length>0){var hH=gL.initialViewPersistent;gL.initialViewPersistent=true;bk.resetView(false);gL.initialViewPersistent=hH}else{bk.resetView(false)}fT.hideUI=gx.makeBool(gx.cfg.hideuiindemomode,true);a.addClass(g9,"fsi-demo-mode");a.addEvent(aw,"click",bi,true);if(fT.hideUI){if(c0){c0.show(false);cG=0}if(gr){gr.enable(false,true)}}var o=gx.cfg.demotooltip;if(!a.isMobileDevice&&typeof(o)==="string"&&o.length>0){fT.bToolTip=true;fT.strTip=o;a.addEvent(aw,"mousemove",ht);a.addEvent(aw,"mouseout",fV)}else{fT.strTip="";fT.bToolTip=false}cM.runPersistent("onEnterDemoMode")};var ht=function(o){if(!fT.oToolTip){if(g7.getToolTip()){fT.oToolTip=g7.getToolTip();fT.bDestroyToolTip=false}else{fT.oToolTip=new a.ToolTip(g9);fT.oToolTip.setContent({});fT.bDestroyToolTip=true}}var hH=a.getElementClientPos(g9);fT.oToolTip.show(fT.strTip,null,o.clientX-hH.left,o.clientY-hH.top,b,100,true)};var fV=function(){if(fT.oToolTip){fT.oToolTip.hide()}};var cL=function(){if(!fT.bEnabled){return}a.removeClass(g9,"fsi-demo-mode");a.removeEvent(aw,"click",bi);if(fT.hideUI){if(c0){c0.show(true);cG=bN}if(gr){gr.enable(true,false)}}if(fT.bToolTip){a.removeEvent(aw,"mousemove",ht);a.removeEvent(aw,"mouseout",fV);fT.oToolTip.hide();if(fT.bDestroyToolTip){fT.oToolTip.destroy();fT.oToolTip=b}}fT.bEnabled=false;fT.hideUI=false;cM.runPersistent("onExitDemoMode")};var bi=function(){if(!fT.bEnabled){return}var hH=gx.cfg.demourl;var hI=gx.cfg.demourltarget;if(!hI){hI="_self"}var o=cM.run("onClickDemoMode",[hH,hI]);if(o===false){return}if(hH==="no action"){return}if(hH==="enter fullscreen"){fT.bRestore=true;if(gx.hasPlugin("fullscreen")){g7.clickMenuButton("ToggleFullScreen",b,true)}}else{window.open(hH,hI)}};var de=function(o){if(gx.cfg.demourl){gj()}else{cL()}gY=b;if(o){dF.log("Skin loaded successfully. ");c1()}else{dF.error("Failed to load skin.");eL={hMenuBar:0};a4._nameParsedLast=b}eo()};this.showMenuButton=function(hH,o){if(c0){c0.showButton(hH,o)}};this.getMenuHeight=function(hH){var o=bN;if(hH!==b){switch(hH){case"navWindow":if(eL.bFloatingNavWindow){o=0}break}}return o};var c1=function(){if(a4._nameParsedLast!==a4.name){a4._nameParsedLast=a4.name;var hM=document.createElement("div");hM.style.position="absolute";hM.style.top="0px";hM.style.left="0px";hM.style.width="1px";hM.style.height="1px";hM.style.overflow="hidden";hM.style.visibility="hidden";var hH=document.createElement("div");hM.appendChild(hH);g9.appendChild(hM);var hO={};var hJ=function(hW,hT,hR,hQ,hS){var hP,hV;if(hO[hW]===b){hH.className=hW;hV=hO[hW]=getComputedStyle(hH,hS)}else{hV=hO[hW]}hP=hV.getPropertyValue(hT);if(hQ){hP=hP.replace(/^[^{]*/g,"");hP=hP.replace(/[^}]*$/g,"");hP=hP.replace(/\\"/g,'"');if(hP.length>0){try{hP=JSON.parse(hP)}catch(hU){a.console.error("ERROR parsing JSON from CSS selector '"+hW+"' property '"+hT+"'.");a.console.error(hU.message)}}else{hP={}}}if(hP===b){hP=hR}return hP};eL=hJ("fsi-ui-info","content",b,true,":before");eL.bFloatingMenuBar=gx.makeBool(eL.floatingMenuBar);eL.bFloatingNavWindow=gx.makeBool(eL.floatingNavWindow);eL.hMenuBar=hJ("fsi-ui-menu-bar","height");a4.urlLogo=hJ("fsi-ui-logo-image","background-image");if(typeof(a4.urlLogo)=="string"){var hL=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=hL.exec(a4.urlLogo);if(o&&o.length>0){a4.urlLogo=o[1]}}a4.navFrameBorderColor=hJ("fsi-ui-nav-frame","border-left-color","red");a4.navFrameBackgroundColor=hJ("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");aA=hJ("fsi-ui-select-frame","border-left-color","red");bv=hJ("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");a4.oProgressBarStyle={};a4.oProgressBarStyle.color=hJ("fsi-ui-progressbar","color","#CCC");a4.oProgressBarStyle.background=hJ("fsi-ui-progressbar","background-color","#FFF");a4.oProgressBarStyle.border=hJ("fsi-ui-progressbar","border-left-color","#CCC");a4.oProgressBarStyle.text=hJ("fsi-ui-progressbar-text","color","#555");var hN=16;var hI=8;if(eL){if(!isNaN(eL.baseSize)&&eL.baseSize>0){hN=eL.baseSize}if(!isNaN(eL.baseEnlargement)&&eL.baseEnlargement>0){hI=eL.baseEnlargement}}else{eL={}}var hK=1;if(a.isMobileDevice&&gL.adaptiveUISize===true){hK=a.getDevicePixelRatio()}ai=Math.round(hN+hI*hK);eL._baseSkinSize=ai;g9.removeChild(hM)}g9.style.fontSize=ai+"px"};var eo=function(){if(typeof(eL.hMenuBar)!="string"||eL.hMenuBar.length<1||isNaN(parseFloat(eL.hMenuBar))){cX=false}else{cX=(d!==true&&!ho)}j()};var eb=function(){if(!cX){c0.removeDomElement()}bN=c0.getHeight();if(eL&&eL.bFloatingMenuBar){cG=0}else{cG=bN}if(fT.bEnabled&&fT.hideUI){c0.show(false);cG=0}am();bz()};this.showMenuToolTip=function(hI,hH,o,hJ){if(c0){c0.showToolTip(hI,hH,o,hJ)}};this.hideMenuToolTip=function(){if(c0){c0.hideToolTip()}};var j=function(){if(f2===b){if(a.getViewerLocation()!==b){f2=new a.ToolTip(g9)}}fW();if(c0===b||!dN){if(c0){c0.destroy()}c0=new a.MenuBar(g7,a4,g9,eb,cQ.oAPI.oMenuCommands);c0.setCallbacks(cM)}else{if(dN&&c0){c0.setInterface(g7)}eb()}};var fW=function(){if(f2!==b&&gL){gx.loadLanguageFile(by,gL.language,go,dF)}};var go=function(hH,o){dS=hH;cM.runPersistent("onLanguageData",[dS]);f2.setContent(dS)};var eX=function(){if(!c0){return}var hM;var hJ=g7.arMenuButtons=[];hJ.push({cmd:"Reset"});if(cd.enabled){hJ.push({cmd:"ZoomOut",enabled:false});hJ.push({cmd:"ZoomIn"})}if(gx.hasPlugin("mousemodes")||gx.hasPlugin("mousemodeselect")){var hH=[0,1];if(hi.length>1){hH.push(2)}if(gx.hasPlugin("measure")){hH.push(100)}var hO={};for(hM=0;hM<hH.length;hM++){hO[hH[hM]]=true}hH=hH.join(",");var hK=gx.getPluginParameter("mousemodes","sequence",hH);var hL=(hK!==hH);hK=hK.split(",");if(hL){var hQ={};for(hM=0;hM<hK.length;hM++){hQ[hK[hM]]=true}for(var hP in hO){if(hO.hasOwnProperty(hP)){if(!hQ[hP]){hK.push(hP)}}}}var hN={};for(hM=0;hM<hK.length;hM++){hN[hK[hM]]=gx.getPluginParameter("mousemodes","mode"+hK[hM],true,true)}if(!cd.enabled){hN[0]=hN[1]=false}var hI=function(hR){if(!hO[hR]||!hN[hR]){return}var hS=true;if(hR===1){hS=(gm>fd)}hJ.push({cmd:"MouseMode_"+hR,groupID:"MouseMode",enabled:hS})};for(hM=0;hM<hK.length;hM++){hI(parseInt(hK[hM]))}}if(gx.hasPlugin("maxzoom")&&cd.enabled){hJ.push({cmd:"MaxZoom"})}if(eS){if(!gx.hasPlugin("hotspots")){gx.addPluginFromString("hotspots")}if(gx.getPluginParameter("hotspots","button","true",true)){hJ.push({cmd:"HotSpots",bCheckButton:true})}dt=gx.getPluginParameter("hotspots","visible","true",true)}if(gL.autoSpinSpeed!==0&&gx.hasPlugin("autospin")&&gx.getPluginParameter("autospin","button",true,true)){hJ.push({cmd:"ToggleAutoSpin",bCheckButton:true})}var o=false;if(gx.hasPlugin("fullscreen")){o=true;a.FullScreen.addChangeEvents(window,cZ,a5);hJ.push({cmd:"ToggleFullScreen",bCheckButton:1})}c0.addButtons(hJ,gL.MenuButtonOrder);cM.run("onInitMenu");if(o&&ei){c0.setButtonPressed("ToggleFullScreen",true)}if(eS&&dt){c0.setButtonPressed("HotSpots",true)}};var fO=function(){var o;if(!s){o=Math.round(Math.max(1,hG)*Math.max(bm.width,bm.height))}else{o=Math.round(Math.max(1,hG)*Math.max(screen.width,screen.height))}fJ=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var bz=function(){if(typeof(gL.virtualSpace)!="object"){return}var hJ=gx.parsePositionParameter(gL.virtualSpace.position);if(hJ!==b){gL.virtualSpace.shiftX=hJ.x;gL.virtualSpace.shiftY=hJ.y;gL.virtualSpace.shiftZ=hJ.z}if(gx.cfg.cameraarmanglestart!==b){if(gx.cfg.cameraarmangleend!==b){gL.virtualSpace.rotationXRange=gL.camera.armAngleEnd-gL.camera.armAngleStart}}if(gL.useDevicePixelRatio){hG=a.getDevicePixelRatio()}else{hG=1}g7.devicePixelRatio=hG;fO();fB=new a.CroppedImage();fB.setCropFromConfig(gx.cfg);switch(gL.panLimits){case"loose":gm=ax;break;case"medium":gm=fd;break;default:gm=fF;break}p();fj=true;if(gL.noSceneLoop){hz=a8}else{hz=fa}J=gL.virtualSpace.rotationYRange*-Math.PI/180;a6.rotXRange=gL.virtualSpace.rotationXRange;a6.rotXGradPerSet=(a6.rotXRange/(a6.nSceneSets-1))*Math.PI/180;if(fR!==b){var hI=fR;fR=b;bk.changeImage.apply(bk,hI);return}var hH=gL.dir;if(hH===b||hH.length===0){hH=gx.cfg.images3durl}if(!hH||hH.length===0||gx.makeBool(gx.cfg.ignoreimagelists)){var o=gx.getImageList();if(o){bY(o.arImages,o.oXML,o)}else{return dk("failed to load image list")}}else{o=gx.loadImageList(hH,bY,cs);if(dF.on&&typeof(o._url)=="string"){dF.log("Loading image list: "+o._url)}}};var bY=function(hH,hI){if(!hH||hH.length<1){dF.error("Failed to load image list.");return dk("image list is empty")}d9();hi=hH;bJ=ak=hH.length;a6=gx.parseSceneSets(hi.length,false);dF.log("Image list ready ("+hi.length+" images)");if(hi.length>0){if(gx.cfg.fpxwidth!==b&&gx.cfg.fpxheight!==b){var o={};o.width=parseInt(gx.cfg.fpxwidth);o.height=parseInt(gx.cfg.fpxheight);b2(null,o)}else{gx.loadImageInfo(hi[0],b2)}}else{bD()}};var cR=function(){var o={};o.angle=gL.camera.armAngleStart;o.stepAngle=gL.virtualSpace.rotationXRange/(a6.nSceneSets-1);return o};var e6=function(){if(!ed||a6.nSceneSets<1){return}if(a6.bSetCameraPosition){return}a6.bSetCameraPosition=true;var hN=new THREE.Vector3();var hH=new THREE.Vector3();var hS=new THREE.Vector3();var hQ=new THREE.Group();var hI=new THREE.Group();hQ.add(hI);var hT=new THREE.Object3D();hI.add(hT);var hM=180/Math.PI;var hX;var hY=dU.targetObj.position;hI.rotation.set(0,0,0);hS.set(0,hY.y,hY.z);if(gx.cfg.cameraarmlength===b){hX=dU.camera.position.distanceTo(hY);gx.cfg.cameraarmlength=hX}else{hX=gL.camera.armLength}var hP=gx.parsePositionParameter(gL.camera.armJointPosition);if(hP===b){hI.position.set(hY.x,hY.y,hY.z);gx.cfg.cameraarmjointposition=hY.x+","+hY.y+","+hY.z}else{hI.position.set(hP.x,hP.y,hP.z)}hI.rotation.x=gL.camera.armAngleMeasureSetup/hM;hQ.rotation.set(0,0,0);hT.rotation.set(0,0,0);hT.position.set(0,0,hX);hQ.updateMatrixWorld();hH.setFromMatrixPosition(hT.matrixWorld);var hW=cR();var hV=hW.angle;var hO=hW.stepAngle;if(gL.reverseSceneSets){hV+=gL.virtualSpace.rotationXRange;hO=-hO}dF.log("Calculated Camera Positions:");dF.log("----------------------------");var o=180/Math.PI;for(var hR=0;hR<a6.nSceneSets;hR++){var hJ=a6.arSets[hR];hJ.cameraArmAngle=hV;hI.rotation.x=hV/hM;hQ.updateMatrixWorld();hN.setFromMatrixPosition(hT.matrixWorld);hJ.posCamera=new THREE.Vector3(dU.camera.position.x+hN.x-hH.x,dU.camera.position.y+hN.y-hH.y,dU.camera.position.z+hN.z-hH.z);hN.x=0;hJ.xAngleToTarget=hS.angleTo(hN)-Math.PI/2;hJ.xAngleToTargetDeg=hJ.xAngleToTarget*o;if(dF.on){dF.log("SceneSet "+(hR+1)+", arm angle "+hV+"°, angle to target: "+hJ.xAngleToTargetDeg+"°, position (x,y,z): "+hJ.posCamera.x+", "+hJ.posCamera.y+", "+hJ.posCamera.z)}if(eS){hJ.visibleHotSpots={};for(var hU=0;hU<gL.hotspots.points.length;hU++){var hK=gL.hotspots.points[hU];var hL=1;if(hK.perimeterAngleX!==b){var hZ=Math.abs(hK.perimeterAngleX-hJ.xAngleToTargetDeg);if(hZ>180){hZ=Math.abs(360-hZ)}if(hZ<hK.perimeterAngleXRange){if(hZ>hK.perimeterAngleXRange-hK.perimeterAngleXFadeOut){hL=(hK.perimeterAngleXRange-hZ)/hK.perimeterAngleXFadeOut}}else{hL=0}hJ.visibleHotSpots[hK.FSIHotspotID]=hL}else{hJ.visibleHotSpots[hK.FSIHotspotID]=1}}}hV+=hO}};var dW=function(){if(a6.bDefault){return}var hK=100000000;var hP=0;var hL,hJ,hO;var hR;if(dF.on){hR=a.utils.cloneObject(a6.arSets)}var hQ={};for(hL=0;hL<a6.arSets.length;hL++){hO=a6.arSets[hL].arScenes;for(hJ=0;hJ<hO.length;hJ++){var hM=hO[hJ]=hO[hJ]-1;hQ[hM]=hi[hM]}}var hN=[];var hI=e.length;for(var hH in hQ){if(hQ.hasOwnProperty(hH)){hN.push(hQ[hH]);hQ[hH]=hI;hI++}}for(hL=0;hL<a6.arSets.length;hL++){hO=a6.arSets[hL].arScenes;for(hJ=0;hJ<hO.length;hJ++){hO[hJ]=hQ[hO[hJ]]}hK=Math.min(hK,hO.length);hP=Math.max(hP,hO.length)}if(a6.arSets[0].arScenes.length>0){a6.bDefault=false;a6.quantizeMin=hK;a6.quantizeMax=a6.quantizeMaxImages=hP;if(dF.on){dF.log('Using SceneSets Parameter: "'+gx.cfg.scenesets+'"');dF.log("Parsed SceneSets:");for(hL=0;hL<hR.length;hL++){dF.log("Scene "+(hL+1)+": "+hR[hL].arScenes.join(", "))}}hi=hN;if(a6.arSets.length>1){if(hK!==hP){a6.bQuantize=true}if(dM!==b&&dM>0){a6.quantizeMax=Math.max(a6.quantizeMax,dM);if(hP!==a6.quantizeMax){a6.bQuantize=true}}}}else{a6.bDefault=true;a6.bHasMultipleSets=false;dF.error('Invalid SecenSet definition: "'+gx.cfg.scenesets+'"')}};var bh=function(){var hJ=100000000;var o=0;for(var hI=0;hI<a6.arSets.length;hI++){var hH=a6.arSets[hI].arScenes;hJ=Math.min(hJ,hH.length);o=Math.max(o,hH.length)}return{min:hJ,max:o}};var gb=function(){var hK,hN;var hH=a6.quantizeMax;for(var hM=0;hM<a6.arSets.length;hM++){if(hM===a6.nVideoSet){continue}var hL=a6.arSets[hM].arScenes;if(hL.length<hH){var o=hL.length;a6.arSets[hM].fQuantizeFactor=hH/o;var hI=o-1;var hJ=new Array(hH);for(hK=0;hK<hH;hK++){hN=(hK*hI/(hH-1));hJ[hK]=hL[Math.round(hN)]}a6.arSets[hM].arScenes=hJ}else{a6.arSets[hM].oSpinPositions=false}}};var bd=function(){var hK,hJ,hL,hI,hP;if(a6.bDefault){return}for(hK=0;hK<a6.arSets.length;hK++){if(hK===a6.nVideoSet){continue}var hQ=a6.arSets[hK];var hN=hQ.arScenes;var hO=hN.length;hP=hI=b;for(hJ=0;hJ<hO;hJ++){hL=hN[hJ];if(hI===b||hI>hL){hI=hL}if(hP===b||hP<hL){hP=hL}}hQ.minScene=hI;hQ.maxScene=hP;hQ.sceneRange=hP-hI;var hH=hQ.sceneRange+1;var o=hQ.oSpinPositions={};var hM=o.arPositions={};for(hJ=0;hJ<hO;hJ++){hL=hN[hJ];hM[hL]=(hL-hI)/hH}}};var dk=function(o){hl();b7("default");if(c0){c0.setEnabled(false)}cM.run("onInitFailed",[o])};var b2=function(hH,o){if(!o||!o.width||isNaN(o.width)){return dk("Failed to load image info")}aD=o;aD.transparency=gx.makeBool(aD.alpha);aD.width=parseInt(aD.width);aD.height=parseInt(aD.height);if(gL.fpxservertemplate!==b){fo.renderer=gL.fpxservertemplate}if(gL.headers!==b){fo.headers=gL.headers}dX=(aD.transparency&&!gL.preventImageTransparency);if(dX){if(i){bB=gL.useMaskedJPEGs;var hI=(gx&&gx.cfg.fpxservertemplate)?gx.cfg.fpxservertemplate.toLowerCase():"";var hJ=(gx&&gx.cfg.imageformat)?gx.cfg.imageformat.toLowerCase():"";if(hI!=="jpeg"&&hJ!=="jpeg"){bB=false}}else{}}hr=true;if(typeof(aD.levels)=="object"&&typeof(aD.levels.sort)=="function"){aD.levels.sort(aV)}else{aD.levels=b}fB.setSourceDimension(aD.width,aD.height);q();l(e4.width,e4.height);d4();bD()};var aV=function(hH,o){return o.width-hH.width};var d4=function(){if(fB.isCropped()){var hH=fB.getImageRect();var o=hH.width()/ad.imageWidth;aZ.cropScaleX=aD.width/hH.width();aZ.cropScaleY=aD.height/hH.height();aZ.x=(hH.left+hH.width()/2-aD.width/2)/o;aZ.y=(hH.top+hH.height()/2-aD.height/2)/o}else{aZ.cropScaleX=1;aZ.cropScaleY=1;aZ.x=0;aZ.y=0}};var q=function(){var o;if(fB.isCropped()){o=fB.getPixelRangeRect();e4.width=o.right;e4.height=o.bottom}else{e4.width=aD.width;e4.height=aD.height}};var bD=function(){if(typeof(a.Easing[gL.easingZoom])==="function"){eO=a.Easing[gL.easingZoom]}else{eO=a.Easing.easeOutCubic}if(typeof(a.Easing[gL.easingSpin])==="function"){dV=a.Easing[gL.easingSpin]}else{dV=a.Easing.easeOutCubic}em();gT();ed=false;bS=false;var o=true;if(a.BrowserSupports.canvas()){if(gL.forceDraw3D||gL.drawCube||gL.drawGroundPlate||gL.drawTable){bS=ed=true}if(!ed&&gL.enableHotspots){if(gL.hotspots&&gL.hotspots.points&&gL.hotspots.points.length>0){ed=true}}if(ed&&cM.isset("on3DWorldChanged")){aM=f9}else{aM=false}var hH="js/three_custom_min.js";if(a.getViewerLocation()!==b){hH=a.getViewerLocation()+"/applications/viewer/"+hH}o=false;if(ed){if(typeof(window.THREE)=="object"){o=true}else{if(!a.loadJavascript(hH,d0,bk,fc)){o=true;ed=false}}}else{a.releaseLoadJavascript(hH,d0);o=true}}if(!ed){bS=false}if(o){dG()}};var fc=function(){if(typeof(window.THREE)!="object"){ed=false}if(!ed){bS=false}dG()};var dG=function(){if(gL.video.spinDirection&&gL.video.spinDirection.toLowerCase()==="left"){gL._reverseVideoDirection=true}if(gL.spinDirectionImage!==b){if(gL.spinDirectionImage.toLowerCase()==="left"){gL._reverseImageDirection=true}}else{gL._reverseImageDirection=gL._reverseVideoDirection}if(!a6.bDefault){if(gL._reverseImageDirection){for(var o=0;o<a6.arSets.length;o++){a6.arSets[o].arScenes.reverse()}gL._reverseImageDirection=false}if(gL.reverseSceneSets){a6.arSets.reverse()}}if(gL._reverseImageDirection){hi.reverse();hi.unshift(hi.pop())}f=az();c4();eX();if(eS){gf(true)}else{gf(false)}if(gt){hC();f6()}cM.run("onDataComplete")};var cJ=function(){if(eP!==b&&c0){c0.setButtonPressed("MouseMode_"+eP,true)}if(bw){c6()}};var c4=function(){if(e4.width){hB=Math.min(cP,e4.width)}else{hB=cP}bs()};var bs=function(){if(!ad.imageX){cd.scaleToSourceImage=Math.max(1,e4.width/bn.imageWidth)}else{cd.scaleToSourceImage=Math.max(1,e4.height/bn.imageHeight)}cd.maxScale=cd.maxScaleInitial=gL.maxZoom/100*cd.scaleToSourceImage;cd.defaultZoom=Math.min(gL.desktopClickZoomScale,cd.maxScale)};this.destroyOnDetach=function(){if(gL&&gL.autoDestroy!==false){gd()}};var gd=this.destroy=function(o){cL();if(h){h=h.destroy()}if(M){M.destroy()}aT.destroy();hw();if(gx){gx.destroy()}if(aw){aw.removeAttribute("data-fsi-id");a.removeClass(aw,"fsi-viewer")}if(m){m.destroy()}if(gY){gY.remove();gY=b}if(bH!==b){a.removeCustomEvent(g9,"FSIMouseWheel",fU);bH=b}if(D!==b){a.removeCustomEvent(hs,"FSIDocumentZoomChange",d7);D=b}if(e8!==b){a.removeCustomEvent(ff,"FSIViewport",bj);e8=b}if(aU){a.removeCustomEvent(window,"FSIViewportSizeChanged",gk);aU=b}if(ha){a.removeCustomEvent(g9,"FSIElementDimension",be);ha=false}if(eh){clearTimeout(eh);eh=b}V();if(f2){f2.destroy();f2=b}er();if(K){K.destroy();K=b}gE=false;gA();if(c0){c0.destroy();c0=b}if(g9){if(gt){a.removeChild(ff,gt);a.removeChild(g9,ff);gt=b}if(g9.parentNode===aw){a.removeChild(aw,g9)}g9=b}if(ac){a.removeChild(ac.parentNode,ac);ac=b}if(hs){if(!a.isMobileDevice){a.removeEvent(hs,"keydown",c7);a.removeEvent(hs,"keyup",ct)}a.removeChild(hs.parentNode,hs);hs=b}if(!o&&cM){cM.run("onDestroy");cM.destroy()}};var p=function(){if(!bm||bm.width<10||bm.height<10){return false}if(hs===b){g7.eventOverlay=hs=document.createElement("div");hs.className="fsi-event-overlay";var hH="position:absolute;z-index:300;width:100%;height:100%;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if(a.isInternetExplorer){a.utils.setStyleAttr(hs,hH+";background-color:rgba(0,0,0,0)")}else{a.utils.setStyleAttr(hs,hH)}b7("wait");if(!a.isMobileDevice){hs.setAttribute("tabIndex","0")}g9.appendChild(hs);if(!K){var hI={};hI.detectGestures=true;hI.afterTouch={enabled:true};hI.afterTouch.modifyTarget=U;hI.afterTouch.fnGetAfterTouchEnabled=br;hI.afterTouch.fnStartStopAfterTouch=N;if(cd.enabled){hI.detectClick=true;hI.onPinchStart=r;hI.onPinchChange=d5;hI.onPinchEnd=g6}K=new a.TouchHandler(hs,hI,eA,ab,fX)}if(!a.isMobileDevice){a.addEvent(hs,"keydown",c7);a.addEvent(hs,"keyup",ct)}if(cd.enabled){bH=a.addCustomEvent(g9,"FSIMouseWheel",fU);a.setCustomEventListenerProperty(bH,"acceleration",1.7);a.setCustomEventListenerProperty(bH,"accelerationMax",30)}else{if(bH!==b){a.removeCustomEvent(g9,"FSIMouseWheel",fU);bH=b}}if(cd.enabled){if(D===b){D=a.addCustomEvent(hs,"FSIDocumentZoomChange",d7);a.triggerCustomEvent(D)}}else{if(D){a.removeCustomEvent(hs,"FSIDocumentZoomChange",d7);D=b}if(K){K.enable(true)}}}if(ac===b&&eS){ac=document.createElement("div");a.addClass(ac,"fsi-ui-hotspot-container");a.utils.setStyleAttr(ac,"position:absolute;z-index:4;");hs.appendChild(ac)}if(ac){fp(ac,false)}if(gt===b||gt.FSIisCanvas!==i){if(gt!==b&&gt.FSIisCanvas!==i){a.removeChild(g9,gt);f8=gt=b4=b}ff=document.createElement("div");ff.setAttribute("draggable","false");a.utils.setStyleAttr(ff,"position:absolute;overflow:hidden;width:100%;height:100%;");if(i){gt=document.createElement("canvas")}else{gt=document.createElement("div")}ff.appendChild(gt);g9.appendChild(ff);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";a.utils.setStyleAttr(gt,o);if(i){cC=gt.getContext("2d");dI=cC.webkitBackingStorePixelRatio||cC.mozBackingStorePixelRatio||cC.msBackingStorePixelRatio||cC.oBackingStorePixelRatio||cC.backingStorePixelRatio||1;if(!eQ){gt.style.width=gt.style.height=""}}else{gt.style.textAlign="left"}gt.FSIisCanvas=i}if(typeof(gL.backgroundColor)=="string"&&gL.backgroundColor.toLowerCase()==="none"){gL.backgroundColor="transparent"}g9.style.backgroundColor=gL.backgroundColor;if(!i){if(f8===b){f8=b4;b4=b}if(b4!==b){a.removeChild(b4.parentNode,b4)}b4=document.createElement("img");if(f8!==b){b4.style.display="none"}gt.appendChild(b4)}if(i){if(e8===b){e8=a.addCustomEvent(ff,"FSIViewport",bj);a.setCustomEventListenerProperty(e8,"treshold",250)}}else{if(e8!==b){a.removeCustomEvent(ff,"FSIViewport",bj);e8=b}bb.setRect(0,0,bm.width,bm.height)}hv=gt.width=Math.ceil(bm.width*aC.scale);c3=gt.height=Math.ceil(bm.height*aC.scale);gt.lastOffsetX=gt.lastOffsetY=0;if((a.BrowserSupports.documentZoom()&&!a.isMobileDevice)||(a.isMobileDevice&&!i)){fY=true}eE();return true};var r=function(o,hI){if(cd.maxScale<=1){fw.bActive=false;return}fw.bActive=true;fw.lastX=hI.x;fw.lastY=hI.y;fw.distanceStart=o._FSI_PinchDistance;var hH=a.getElementPosition(hs);fw.offsetX=-hH.left-bm.width/2;fw.offsetY=-hH.top-bm.height/2;fw.startZoom=cd.scale;aW(false)};var d5=function(hJ,hN){if(!fw.bActive){return}if(bl>1.2){hJ.FSI_allowEventDefault=true;return}var hL=hN.x-fw.lastX;var hK=hN.y-fw.lastY;fw.lastX=hN.x;fw.lastY=hN.y;var hI=fw.startZoom*hJ._FSI_PinchScale;hI=Math.max(1,Math.min(cd.maxScale,hI));var o=hN.x+fw.offsetX;var hM=hN.y+fw.offsetY;var hH=hI/cd.scale;cd.panPos.left-=o;cd.panPos.top-=hM;cd.panPos.left*=hH;cd.panPos.top*=hH;cd.panPos.left+=o;cd.panPos.top+=hM;cd.panPos.left+=hL;cd.panPos.top+=hK;eM(hI,true,false)};var g6=function(){if(!fw.bActive){return}fw.bActive=false;aW(true);var o=cd.scale;eM(o,false,false)};var O=function(hH){bl=hH;var o=hG;if(o<1||gL.useDevicePixelRatio){hH=o*hH}if(fC!==hH){fC=hH;cd.maxScale=Math.max(1,cd.maxScaleInitial/hH);dR();cp=hH}};var eV=function(){var hH=false;if(a.FullScreen){hH=a.FullScreen.getElement()}var o=fK();return(hH&&hH!==o)};var bj=function(o){if(eV()){return}cc=o.FSI_viewport_rect;O(o.FSI_scale);if(!cv){return}t(o.FSI_after_treshold)};var d7=function(){fk()};var fk=function(){if(gL.autoDisablePointerActions){var hH=a.getViewportSize();var o=(bk.getInFullScreenMode()||(Math.floor(ao.width)<=hH.width&&Math.floor(ao.height)<=hH.height));if(o!==gM){gM=o;K.enable(o);if(gr){gr.enable(o)}}}};var aY=function(){return(df&&(!K||!K.isAfterTouchRunning()))};var fU=function(hO){g7.onUserAction();if(fT.bEnabled||!hO.FSI_delta){return}aI(false);if(hO.preventDefault){hO.preventDefault()}A();bZ();var hP=aY();if(ck||hP){return}if(cd.maxScale<=1){return}var hN=0.45*hO.FSI_normalized_accelerated_delta;cH=K.getMousePositionClient(hO);var hM=a.getElementPosition(hs);var hI=1+Math.abs(hN)/6;if(hN<0){hI=1/hI}var hQ=Math.max(1,Math.min(cd.maxScale,cd.scale*hI));var hL=cH.x*aC.scale-hM.left-bm.width*aC.scale/2;var hK=cH.y*aC.scale-hM.top-bm.height*aC.scale/2;var o=hQ/cd.scale;var hJ=cd.panPos.left-hL;var hH=cd.panPos.top-hK;hJ*=o;hH*=o;hJ+=hL;hH+=hK;I=a.Easing.easeOutQuart;eZ(hJ,hH,hQ,13);if(gr&&gr.isDragging()){cd.lockPanAnimation=true}hO.cancelBubble=true};var N=function(o){g1=o;if(o){hq()}};var gN=function(){if(!d8){return}aF=false;if(d8._timeOutDraw){clearTimeout(d8._timeOutDraw)}d8=b};var eR=function(){if(!gL.showProgressbar){return}if(hi.length<2){gN();return}if(!i){return}var o=0;switch(gL.progressBarHAlign){case"left":case"right":o=8;break}eg=Math.max(10,(bm.width*(Math.max(0,Math.min(100,gL.progressBarWidth/100)))-2*o))*aC.scale;dY=Math.max(1,Math.min(bm.height,gL.progressBarHeight))*aC.scale;d8=new a.CanvasProgressBar(cC,0,0,eg,dY,a4.oProgressBarStyle);cT();d8._timeOutDraw=setTimeout(bG,100)};var bG=function(){if(d8){aF=true}};var cT=function(){if(!d8){return}var o,hH;switch(gL.progressBarHAlign){case"left":o=aC.scale*8;break;case"right":o=aC.scale*(bm.width-eg-8);break;default:o=aC.scale*((bm.width-eg)/2)}switch(gL.progressBarVAlign){case"middle":case"center":hH=aC.scale*(bm.height/2-dY/2);break;case"top":hH=aC.scale*4;break;default:hH=aC.scale*(bm.height-4-dY)}d8.setPos(o,hH)};var f6=function(){var hT;cK(0);var hL=false;aO=(!a.isMobileDevice&&(a.isOpera||a.isInternetExplorer));eR();b7("wait");var hN="";if(f.indexOf("//")===-1){hN=gL.video.base}if(!i||a.isMobileDevice||!f){dF.log("Using image sequence w/o video.");return dp()}var hR=gL.video.captureOffsetStart;if(hR===b||isNaN(hR)){hR=0}var hJ=gL.video.captureOffsetEnd;if(hJ===b||isNaN(hJ)){hJ=0}var hM;hT=gL.video.captureFrames;if(hT===b||isNaN(hT)){gL.video.captureFrames=120}if(a6.nSceneSets>1){var hO=bh();gL.video.captureFrames=Math.max(gL.video.captureFrames,hO.max)}else{gL.video.captureFrames-=gL.video.captureFrames%hi.length;gL.video.captureFrames=Math.max(gL.video.captureFrames,hi.length)}var hS=document.createElement("canvas");hS.setAttribute("webkit-playsinline","");var hP=hS.getContext("2d");if(!dB){dB=document.createElement("canvas");hA=dB.getContext("2d")}hT=hN+f;if(a.isInternetExplorer&&a.versionInternetExplorer<10&&a.utils.isCrossDomain(hT)){dF.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");dF.log("Falling back to using image sequence.");return dp()}dF.log("Capture "+gL.video.captureFrames+" video frames");dZ=document.createElement("video");dZ.setAttribute("muted","muted");dZ.setAttribute("preload","auto");dZ.setAttribute("webkit-playsinline","");dZ.setAttribute("crossorigin","anonymous");a.utils.setStyleAttr(dZ,"position:absolute;z-index:10000;width:1px;height:1px");if(a.isSafari){dZ.style.display="none"}dZ.style.marginLeft=bm.width/2+"px";dZ.style.marginTop=bm.height/2+"px";if(!a.isSafari&&!a.isInternetExplorer){var hI=document.createElement("source");hI.setAttribute("src",hN+f+".webm");dZ.appendChild(hI)}var hH=document.createElement("source");hH.setAttribute("src",hN+f+".mp4");dZ.appendChild(hH);if(!a.isSafari&&!a.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",hN+f+".ogv");dZ.appendChild(hH)}g9.appendChild(dZ);dZ.FSIEvents={};var hQ=function(hV,hW,hU){dZ.FSIEvents[hV]={fn:hW,phase:hU};a.addEvent(dZ,hV,hW,hU)};hQ("error",function(){if(dZ.networkState===dZ.NETWORK_NO_SOURCE){dF.error('Failed loading the video: "'+f+'"');dF.log("Falling back to using image sequence w/o video.");dp()}},true);hQ("loadedmetadata",function(){ck=true;ew("video");var hV=dZ.videoWidth;var hU=dZ.videoHeight;dZ.setAttribute("width",hV);dZ.setAttribute("height",hU);hM=(dZ.duration-hR-hJ)/gL.video.captureFrames;gV(hV,hU);hS.setAttribute("width",c2.croppedWidth);hS.setAttribute("height",c2.croppedHeight);dB.setAttribute("width",c2.croppedWidth);dB.setAttribute("height",c2.croppedHeight);cJ();hf()},true);hQ("canplaythrough",function(){if(!hL){if(a.isSafari){dZ.style.display=""}hL=true;this.currentTime=Math.max(0,hR)}},true);var hK=0;hQ("seeked",function(hU){if(!ck){return}var hV=dZ.duration;if(a.isInternetExplorer){hV-=0.3}if(e.length<gL.video.captureFrames){try{hP.drawImage(hU.target,0,0,c2.width,c2.height,-fA.left,-fA.top,c2.width,c2.height);var hX=hP.getImageData(0,0,hS.width,hS.height);e.push(hX)}catch(hW){dF.error('Failed capturing the video: "'+f+'"');dF.log("REASON: "+hW.message);dF.log("Falling back to using image sequence w/o video.");ck=false;dp();return}cK(100*e.length/gL.video.captureFrames);cm(e.length-1);hq();hK=Math.min(hV,hM*e.length+hR);if(aO){eh=setTimeout(function(){dZ.currentTime=hK},1)}else{dZ.currentTime=hK}}else{dd()}},true)};var fQ=this.startAutoSpin=function(){if(!cv||!gh.bEnabledByConfig){return false}if(gh.interval){return true}if(c0){c0.setButtonPressed("ToggleAutoSpin",true)}A();b0();b9("autoSpin");gh.enabled=true;eG();gh.interval=setInterval(f7,gh.nIntervalTime);return true};var gR=function(){if(!cv||!gh.bEnabledByConfig){return false}if(!gh.enabled){fQ()}else{aI(true)}};this.stopAutoSpin=function(){return aI()};var aI=g7.stopAutoSpin=function(o){if(!cv||!gh.bEnabledByConfig){return false}if(!gh.interval){return true}if(c0){c0.setButtonPressed("ToggleAutoSpin",false)}gh.enabled=false;gz("autoSpin");clearInterval(gh.interval);gh.interval=b;if(o){eU()}return true};var f7=function(){if(!hE){b9("autoSpin")}var o=eI+gh.nDirection;if(o>=ex){o-=ex}else{if(o<0){o+=ex}}hg(o);hq()};var a0=function(hH){ex=hH;var o=1;if(typeof(gL.fMouseSensitivity)!="undefined"){o=parseFloat(gL.fMouseSensitivity);if(isNaN(o)||o===0){o=1}}fD=160/ex*4/o;dP=ex/120};var gG=function(){var o;if(!a6.bDefault&&a6.nSceneSets>1){o=Math.max(1,Math.min(a6.nSceneSets,gL.video.sceneSet))-1;if(gL.reverseSceneSets){o=(-(o+1)+a6.nSceneSets)%a6.nSceneSets}}return o};var dd=function(){if(gL._reverseVideoDirection){e.reverse();e.unshift(e.pop())}bC.unshift(x.imageWidth);fM=e.length;if(e.length>0){a6.nVideoSet=gG()}else{a6.nVideoSet=b}if(a6.nVideoSet!==b){var o=hd;dp();hd=o}else{dW();ca()}};var fn=function(){if(n){n.destroy()}if(gx.hasPlugin("measure")){n=new a.PluginMeasure(bk,g7)}};var ca=function(){var hH;cK(100);hl();if(cl!==b){gi=cl}fn();bd();if(a6.bQuantize){gb()}cm(0);aF=false;bV=ed;cB=b;if(gL._reverseImageDirection&&gr){gr.reverseImageSequence()}if(e3){hq()}eu();gN();bt();bL=false;gh.bEnabledByConfig=false;if(ex>1||a6.nSceneSets>1){z=false;if(a.isIETouch){if(a6.nSceneSets>1){hs.style.msTouchAction="pinch-zoom double-tap-zoom"}else{hs.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}}if(gL.autoSpinSpeed||gL.autoSpinInterval){if(gL.autoSpinInterval){hH=gL.autoSpinInterval;gh.nDirection=(hH>0)?1:-1;hH=Math.abs(hH)}else{if(gL.autoSpinSpeed<0){gL.autoSpinSpeed=-gL.autoSpinSpeed;gh.nDirection=-1}else{gh.nDirection=1}hH=gL.autoSpinSpeed*1000/ex;if(!hH){hH=1}while(hH<20&&Math.abs(gh.nDirection)<ex/2){hH*=2;gh.nDirection*=2}hH=Math.max(20,Math.ceil(hH))}gh.nIntervalTime=hH;gh.bEnabledByConfig=true;if(!gx.hasPlugin("autospin")||gx.getPluginParameter("autospin","enabled",true,true)){bL=gx.getPluginParameter("autospin","restartonreset",false,true);cv=true;fQ();cv=false}}}else{z=true;if(a.isIETouch){hs.style.msTouchAction=b}if(!cd.enabled){b7("default")}}hH=gL.initialMouseMode;if(hH!=="auto"){hH=parseInt(hH)}fm(hH);ck=false;var o=b;if(gL.video.frameOffset&&hd){o=eI+gL.video.frameOffset;o=hz(ex+o);cm(o)}cj();cv=true;if(e8){a.triggerCustomEvent(e8);t(true)}if(c0){c0.setEnabled(true)}if(c!==b){he(c,(hi.length>1));c=b}else{if(av!==b&&gx.makeBool(gx.cfg.keepcurrentviewafterconfigchange,false)){gL.initialview=av}if(gL){if(typeof(gL.initialview)==="string"&&gL.initialview.length>0){if(!he(gL.initialview,false)){gL.initialview=b}else{gL.initialview=gx.fillViewString(gL.initialview)}}else{gL.initialview=b}}}av=b;if(dF.on){dF.log("Startup time: "+(a.now()-dg)+"ms")}cM.run("onReady");co();if(cd.enabled){cb()}if(!cd.enabled){if(z){K.setCapture(false,false)}else{K.setCapture(true,false)}}cM.runPersistent("onAfterReady");an()};var dp=function(){hw();dM=e.length;ew("image");hf();dW();eu();l(e4.width,e4.height);cJ();fx()};var dz=function(){a.removeEvent(b4,"load",dz);if(f8!==b&&f8.parentNode){a.removeChild(f8.parentNode,f8);f8=b}b4.style.display="inline";gt.style.paddingLeft=ad.imageX+"px";gt.style.paddingTop=ad.imageY+"px"};var fx=function(){ck=true;if(!i){b4.width=ad.imageWidth;b4.height=ad.imageHeight;a.addEvent(b4,"load",dz,true);if(f8===b){try{gt.style.paddingLeft=gt.style.paddingRight="auto";gt.style.paddingTop=gt.style.paddingRight="auto"}catch(o){}}}if(dB){dB.setAttribute("width",ad.imageWidth);dB.setAttribute("height",ad.imageHeight)}fl()};var fb=function(o){if(o){e5()}else{hl()}};var gc=function(o,hI,hJ,hH){var hK;o.FSI_image_context=o;if(bB){hI=a.utils.removeFormatInURL(hI);hK={};hK.argsJPEG=Array.prototype.slice.call(arguments);hK.argsJPEG[1]=a.utils.setRendererInURL(hI,"jpeg");hH=dA;hI=a.utils.setRendererInURL(hI,"png.alpha");o=hK.argsJPEG[0].FSI_alpha_channel=new Image()}aT.load(o,hI,hJ,hH,hK)};var dA=function(o,hH){aT.load.apply(this,hH.argsJPEG)};var cz=function(hI){if(!hI){return}if(hI.FSI_alpha_channel){var hH=hI.width;var hK=hI.height;var hJ=hI.FSI_image_context=document.createElement("canvas");hJ.setAttribute("width",hH);hJ.setAttribute("height",hK);hJ.setAttribute("crossorigin","anonymous");var o=hJ.getContext("2d");o.drawImage(hI.FSI_alpha_channel,0,0,hH,hK);o.globalCompositeOperation="xor";o.drawImage(hI,0,0,hH,hK);hI.FSI_alpha_channel=b}};var cK=function(o){af=o;if(cU){cM.runPersistent("onProgress",[o])}};var fl=function(){eB={};eB.oImages={};eB.nPendingImages=0;eB.nNext=0;eB.nCurrentIndex=-1;eB.nLoaded=0;eB.nAddedPreview=0;if(!i){eB.img=new Image()}var hH=Math.min(6,hi.length);for(var o=0;o<hH;o++){F()}};var gQ=function(){eB.nLoaded++;cK(100*eB.nLoaded/hi.length);if(eB.nNext!==this.FSI_nImage){eB.oImages[this.FSI_nImage]=this;eB.nPendingImages++}else{b1(this);d2()}F()};var d2=function(){if(eB&&eB.nPendingImages>0){while(eB&&eB.oImages[eB.nNext]){var hH=eB.nNext;var o=eB.oImages[hH];eB.oImages[hH]=b;eB.nPendingImages--;b1(o)}}};var b1=function(o){eB.nAddedPreview++;eB.nNext++;cz(o);if(i){e.push(o)}else{e.push(o.src)}cm(e.length-1);hq();if(eB.nAddedPreview>=hi.length){d2();aq();if(e3){e3.addImage(b4)}ca()}};var F=function(){if(!eB||++eB.nCurrentIndex>=hi.length){return}var o;if(i){o=e9=new Image();o.FSI_nImage=eB.nCurrentIndex}else{o=eB.img}gc(o,g5(eB.nCurrentIndex).fullURL,"sequence",gQ)};var aq=function(){if(eB===b){return}aT.abortPurpose("sequence");eB=b};var hg=function(o){var hH=hz(Math.round(o));if(hH!==hz(eI)){dR();cm(hH);hq();if(cv&&fL===b&&gh.interval===b){an()}}en=o};var b9=function(){if(hE){return}Y=true;hE=true;V();db=false;C=false};var gz=function(){if(!hE){return}cm(hz(eI));hE=false;db=true;C=true;if(!du||eI!==du.spinPos){if(du){fz()}ft()}else{c5(50)}};var cm=function(o){eI=en=o;if(!a1){dv=eI}else{dv=a1[eI]}};var cA=function(){var o,hM,hI;ek=document.createElement("canvas");ek.setAttribute("width",c2.croppedWidth);ek.setAttribute("height",c2.croppedHeight);ev=ek.getContext("2d");var hK=ek.width;var hH=ek.height;var hJ=ev.createImageData(hK,hH);var hL=hJ.data;for(hM=0;hM<hH;hM++){if(hM%4===0){for(o=0;o<hK;o++){if(o%4!==0){hI=hM*hK*4+o*4;hL[hI]=0;hL[hI+1]=0;hL[hI+2]=0;hL[hI+3]=255}}}else{if(hM%4===1||hM%4===2){for(o=1;o<hK;o+=4){hI=hM*hK*4+o*4;hL[hI]=0;hL[hI+1]=0;hL[hI+2]=0;hL[hI+3]=255}}}}ev.putImageData(hJ,0,0)};var hq=g7.drawScene=function(){if(P!==b||fe){return}P=requestAnimationFrame(aB)};var hw=function(){if(P===b){return}cancelAnimationFrame(P);P=b};var bo=g7.render3D=function(){dU.renderer.render(dU.scene,dU.camera)};var aB=g7.doDrawScene=function(){P=b;var hH=false;if(g1&&K.runAfterTouch()){hH=true}if(!i){if(a9!==dv){b4.src=e[dv];a9=dv}}else{if(X&&fH()){hH=true}cC.globalAlpha=1;cC.clearRect(0,0,hv,c3);gi();if(db&&du){if(hF()){hH=true}}}if(bV){if(hk){var hM=hj*bm.width;var hJ=hj*bm.height;hk=false;var hK=-aC.drawOffsetX+(hM-bm.width*aC.scale)/2-cd.panPos.left+aZ.x*cd.scale;var hI=-aC.drawOffsetY+(hJ-bm.height*aC.scale)/2-cd.panPos.top+aZ.y*cd.scale;dU.camera.setViewOffset(hM,hJ,hK,hI,aC.totalWidth,aC.totalHeight)}if(dm){eD()}if(bS){bo()}if(dm){dm=false;if(eS&&d6){if(!bS){bo()}bU()}}}if(gU){gU=false;if(gr){gr.update(dv,hj)}}if(ga){gH();cC.fillStyle=bv;cC.fillRect(gX.left+1,gX.top+1,gX.width()-1,gX.height()-1);cC.fillStyle=aA;cC.fillRect(gX.left,gX.top,gX.width(),1);cC.fillRect(gX.left,gX.bottom,gX.width(),1);cC.fillRect(gX.left,gX.top,1,gX.height());cC.fillRect(gX.right,gX.top,1,gX.height())}if(aF){d8.draw(af)}if(dq){if(cg){g(gt,"translate3d("+aC.left+"px,"+aC.top+"px,0px)"+aC.strTransformScale)}else{g(gt,"translate("+aC.left+"px,"+aC.top+"px)"+aC.strTransformScale)}}if(hH){hq()}if(eY){var hL=[aC,hj,cd];for(var hN in T){if(T.hasOwnProperty(hN)){T[hN].apply(bk,hL)}}}};g7.addDrawListener=function(hH,o){if(!hH||typeof(o)!=="function"){return false}if(T&&T[hH]){return false}if(!T){T={}}T[hH]=o;eY=true;return true};g7.removeDrawListener=function(hH){if(!hH){return false}if(!T||!T[hH]){return false}delete T[hH];var hJ=0;for(var hI in T){hJ++}if(hJ===0){T=b;eY=false}return true};var eD=function(){var o;if(cY.oSpinPositions){o=cY.oSpinPositions.arPositions[dv]}else{o=eI/ex}fv(0,o*J,0)};var gH=function(){gX.copyRect(aS);gX.offsetRect(-aS.clientOffset.left,-aS.clientOffset.top);gX.normalizeRect();if(aC.scale!==1){gX.scaleRect(aC.scale)}};var dR=function(){dm=gU=true};var ez=function(){return false};var R=function(o){cC.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};g7.getAccessToken=function(){return a3};this.setAccessToken=function(o){a3=o;if(gx){gx.setAccessToken(a3)}};var g2=function(hH){var o;hH.alpha+=fh;if(hH.alpha>=1){hH.fnDraw=R;hH.alpha=1;o=false}else{o=true}cC.globalAlpha=hH.alpha;R(hH);cC.globalAlpha=1;return o};var hF=function(){var o=false;if(C){hc()}if(du.nVisibleTiles>0){var hL=aC.drawOffsetX+ad.imageX+cd.panPos.left;var hK=aC.drawOffsetY+ad.imageY+cd.panPos.top;var hJ=ad.imageWidth/du.width;cC.save();cC.translate(hL,hK);cC.scale(hJ,hJ);var hH=du.arVisibleTiles;for(var hI=0;hI<du.nVisibleTiles;hI++){if(hH[hI].fnDraw(hH[hI])){o=true}}cC.restore()}du.bTilesFading=o;if(!hx&&Y&&!o&&du.bFilesArePreparedForLoading){if(!cB||(cB.nTilesLoading===0&&du.arTilesToLoad.length===0)){Y=false}}return o};var ew=function(o,hH){fr=(o==="video");if(fr){eW=b;dE=dB;b5=g7.getPreviewImage=aL;gi=cw}else{b5=g7.getPreviewImage=cN;gi=gK}if(!hH){hd=fr;if(gL){if(hi.length>1){if(!gL.showPreviewWhileLoading){cl=gi;gi=a.fnDoNothing}else{if(!gL.spinPreviewWhileLoading){cl=gi;if(!aJ.bSetup){aJ.bStillPreview=true;gi=a.fnDoNothing}else{if(aJ.imgDraw){gi=gv}else{gi=a.fnDoNothing}}}else{cl=b}}}aJ.bSetup=true}}};var hf=function(){if(!aJ.bStillPreview||aJ.bStillPreviewDone){return}gP()};var gP=function(){aJ.bStillPreviewDone=true;var hI=cv;cv=true;var hJ;var hK=eC(gL.initialview);if(a6.bDefault){hJ=hK.scene}else{var hH=a6.arSets[hK.SceneSet];hJ=hH.arScenes[hK.scene]-1}bX();var o=g5(hJ).fullURL;aJ.img=new Image();gc(aJ.img,o,"stillPreview",E);cv=hI;bF=b};var E=function(){cz(this);aJ.imgDraw=this.FSI_image_context;gi=gv};var gv=function(){aE(aJ.imgDraw,ad.imageX,ad.imageY,hj)};var aL=function(o){if(eW===o){return dE}eW=o;hA.putImageData(e[o],0,0);dE=dB;return dE};var cN=function(o){if(eW===o){return dE}if(!da){da=x.imageWidth;if(hr){aH=document.createElement("canvas");aH.setAttribute("width",x.imageWidth);aH.setAttribute("height",x.imageHeight);hn=aH.getContext("2d")}}if(!e[o]){eW=b}else{if(!hr){dE=e[o].FSI_image_context}else{if(dX){hn.clearRect(0,0,aH.width,aH.height)}hn.drawImage(e[o].FSI_image_context,0,0,x.imageWidth,x.imageHeight);dE=aH}eW=o}return dE};var cw=function(){cC.globalAlpha=1;var o=hj*x.videoWidth/c2.croppedWidth;aE(aL(dv),ad.videoX,ad.videoY,o);if(Y&&gL.pellets&&!H){cC.globalAlpha=gL.pelletsOpacity;cC.globalCompositeOperation="xor";aE(ek,ad.videoX,ad.videoY,o);cC.globalAlpha=1;cC.globalCompositeOperation="source-over"}};var gK=function(){aE(cN(dv),ad.imageX,ad.imageY,hj)};var aE=function(hJ,hQ,hN,hH){if(!hJ){return}var hP=0;var hO=0;var hK=aC.drawOffsetX+hQ+cd.panPos.left;var hI=aC.drawOffsetY+hN+cd.panPos.top;if(hK<0){hP=-hK/hH;hK=0}if(hI<0){hO=-hI/hH;hI=0}var hR=hJ.width-hP;var hM=hJ.height-hO;var hL=hR*hH;var o=hM*hH;cC.drawImage(hJ,hP,hO,hR,hM,hK,hI,hL,o)};g7.getImagePos=function(hJ){var hI,o,hH,hK;if(hJ){hI=bn.imageXAbsolute;o=bn.imageYAbsolute;hH=bn.imageWidthAbsolute;hK=bn.imageHeightAbsolute}else{hI=aC.drawOffsetX+(ad.imageX+cd.panPos.left)/aC.scale;o=aC.drawOffsetY+(ad.imageY+cd.panPos.top)/aC.scale;hH=ad.imageWidth/aC.scale;hK=ad.imageHeight/aC.scale}return{x:hI,y:o,width:hH,height:hK}};var c6=function(){if(gr){er()}if(cd.enabled&&i){gr=new a.NavigatorWindow(g7,gx,a4,g9,dS);if(fT.hideUI){gr.enable(false,true)}}};var er=function(){if(!gr){return}gr.destroy();gr=b};var cn=function(){if(!ed||!dU.targetObj){return}var hJ=bm.width*aC.scale;var hN=bm.height*aC.scale;dU.sceneWidth=bn.imageWidth*aZ.cropScaleX;dU.sceneHeight=bn.imageHeight*aZ.cropScaleY;var hK=dU.sceneWidth;var o=hK/1.5;var hM=o/hN;var hL=gL.camera.digitalCropFactor*gL.camera.focalLength*hM;var hH=2*THREE.Math.radToDeg(Math.atan(24/hL/2));dU.camera=new THREE.PerspectiveCamera(hH,dU.sceneWidth/dU.sceneHeight,0.1,10000);var hI=gx.parsePositionParameter(gL.camera.position);if(hI!==b){a7.x=hI.x;a7.y=hI.y;a7.z=hI.z}else{if(gL.camera.heightTable!==b&&gL.camera.heightCamera!==b){gL.camera.heightAboveTable=gL.camera.heightCamera-gL.camera.heightTable}if(gL.camera.shiftX===b){gL.camera.shiftX=0}a7.x=gL.camera.shiftX;a7.y=gL.camera.heightAboveTable;a7.z=gL.camera.distanceToTableCenter}if(a7.x===b){a7.x=0}if(a7.y===b){a7.y=0}if(a7.z===b){a7.z=0}dU.camera.position.x=a7.x;dU.camera.position.y=a7.y;dU.camera.position.z=a7.z;gx.cfg.cameraposition=a7.x+","+a7.y+","+a7.z;e6();dU.camera.lookAt(dU.targetObj.position);dU.camera.rotation.z=0;fq();dU.camera.setViewOffset(hJ,hN,-aC.drawOffsetX+aZ.x,-aC.drawOffsetY+aZ.y,hJ,hN)};var Q=function(){var o=Math.PI/180;gL.virtualSpace.baseRotationXRad=-gL.virtualSpace.baseRotationX*o;gL.virtualSpace.baseRotationYRad=-gL.virtualSpace.baseRotationY*o;gL.virtualSpace.baseRotationZRad=-gL.virtualSpace.baseRotationZ*o;gL.camera.armAngleStartRad=gL.camera.armAngleStart*o};var hC=function(){if(!ed){return}var h8;h8=window.THREE;var h7={};if(a.BrowserSupports.canvas()&&typeof h8!=="undefined"){if(i){dU.renderer=new h8.CanvasRenderer({canvas:gt,clearColor:0,clearAlpha:0,devicePixelRatio:1});dU.renderer.autoClear=false;h7.width=bm.width*aC.scale;h7.height=bm.height*aC.scale}else{dU.renderer=new h8.CanvasRenderer({clearColor:0,clearAlpha:0});dU.renderer.autoClear=false;h7.width=bm.width;h7.height=bm.height}dU.scene=new h8.Scene();dU.objects=new h8.Group();var hR=new h8.Object3D();var h6=gx.parsePositionParameter(gL.camera.targetPosition);if(h6===b){hR.position.x=gL.camera.targetWidthOffset;hR.position.y=gL.camera.targetHeightOffset;hR.position.z=0;gx.cfg.cameratargetposition=hR.position.x+","+hR.position.y+","+hR.position.z}else{hR.position.x=h6.x;hR.position.y=h6.y;hR.position.z=h6.z}dU.scene.add(hR);dU.targetObj=hR;var hQ;if(gL.virtualSpace.cubeLineWidth>0&&gL.drawCube){var hW=gL.virtualSpace.cubeSegments;hW=Math.max(1,Math.min(10,hW));var h4,hI;if(gL.virtualSpace.cubeSizeX){h4=new h8.BoxGeometry(gL.virtualSpace.cubeSizeX,gL.virtualSpace.cubeSizeY,gL.virtualSpace.cubeSizeZ,hW,hW,hW);hQ=gL.virtualSpace.cubeSizeY/2}else{h4=new h8.BoxGeometry(gL.virtualSpace.cubeSize,gL.virtualSpace.cubeSize,gL.virtualSpace.cubeSize,hW,hW,hW);hQ=gL.virtualSpace.cubeSize/2}hI=new h8.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:gL.virtualSpace.cubeLineWidth});var hM=new h8.Mesh(h4,hI);if(gL.virtualSpace.shiftY===b){gL.virtualSpace.shiftY=0}hM.position.x=gL.virtualSpace.shiftX;hM.position.y=hQ+gL.virtualSpace.shiftY;hM.position.z=gL.virtualSpace.shiftZ;dU.cube=hM;dU.objects.add(hM)}if(gL.drawGroundPlate){var hJ=new h8.GridHelper(Math.max(gL.virtualSpace.cubeSizeX,gL.virtualSpace.cubeSizeY),15,new h8.Color(15626314),new h8.Color(15626314));hJ.position.set(gL.virtualSpace.shiftX,gL.virtualSpace.shiftY,gL.virtualSpace.shiftZ);dU.objects.add(hJ);dU.plane=hJ}if(gL.drawTable){var o=gL.tableDiameter/2;var h0=50;var hH=new h8.Geometry();var h9;h9=Math.PI*2/360;var hX=0;var hN=function(id,ic){var ig=0;var ih=0;var il=0;var ie=0;for(var ii=0;ii<=36;ii++,hX+=4){var ib=Math.sin(h9*ii)*id;var ik=Math.cos(h9*ii)*id;var ia=Math.sin(h9*ii)*ic;var ij=Math.cos(h9*ii)*ic;hH.vertices.push(new h8.Vector3(ia,ij,0));hH.vertices.push(new h8.Vector3(il,ie,0));hH.vertices.push(new h8.Vector3(ig,ih,0));hH.vertices.push(new h8.Vector3(ib,ik,0));hH.faces.push(new h8.Face3(hX,hX+1,hX+2));ig=ib;ih=ik;il=ia;ie=ij}};var hO=0;var hL=0;for(var h5=0;h5<=4;h5++,hX+=3){var hU=Math.sin(h9*h5*90)*h0;var hT=Math.cos(h9*h5*90)*h0;hH.vertices.push(new h8.Vector3(0,0,0));hH.vertices.push(new h8.Vector3(hU,hT,0));hH.vertices.push(new h8.Vector3(hO,hL,0));hH.faces.push(new h8.Face3(hX,hX+1,hX+2));hO=hU;hL=hT}h9=Math.PI*2/36;var hZ=0;var hY=h0;while(hY<o){hZ+=h0;hY=hZ+h0;if(hY>o){hY=o}hN(hZ,hY)}var h3=new h8.Mesh(hH,new h8.MeshBasicMaterial({color:5810431,wireframe:true}));h3.rotation.x=-Math.PI/2;dU.disk=h3;dU.objects.add(h3)}if(gL.hotspots&&gL.hotspots.points){a2();gD=gL.hotspotCallbackFunction;if(typeof(gD)=="string"){try{gD=window[gD]}catch(h2){}}else{if(typeof(gD)!="function"){gD=b}}var hV=1;eN={};for(var h1=0;h1<gL.hotspots.points.length;h1++,hV++){var hP=gL.hotspots.points[h1];hP.FSIHotspotID=hV;eN[hV]=hP;if(hP.perimeterAngle!==b&&hP.perimeterAngleY===b){hP.perimeterAngleY=hP.perimeterAngle;hP.perimeterAngleYRange=hP.perimeterAngleRange;hP.perimeterAngleYFadeOut=hP.perimeterAngleFadeOut}if(hP.perimeterAngleY&&hP.perimeterAngleY<0){hP.perimeterAngleY=360+hP.perimeterAngleY}hP.perimeterAngleYFadeOut=Math.min(hP.perimeterAngleYRange,hP.perimeterAngleYFadeOut);if(hP.perimeterAngleX!==b&&hP.perimeterAngleX<0){hP.perimeterAngleX=360+hP.perimeterAngleX}hP.perimeterAngleXFadeOut=Math.min(hP.perimeterAngleXRange,hP.perimeterAngleXFadeOut);if(gL.hotspots.defaults){for(var hK in gL.hotspots.defaults){if(gL.hotspots.defaults.hasOwnProperty(hK)){if(hP[hK]===b){hP[hK]=gL.hotspots.defaults[hK]}}}}dx(hP);var hS=new h8.Object3D();hS.position.x=hP.x+gL.virtualSpace.shiftX;hS.position.y=hP.y+gL.virtualSpace.shiftY;hS.position.z=hP.z+gL.virtualSpace.shiftZ;hP.object=hS;dU.objects.add(hS)}dF.log(h1+" HotSpots created.")}dU.scene.add(dU.objects);dQ(h7.width,h7.height);cn()}eD();if(gW){L()}cM.run("onInit3D",[dU]);if(aM){aM()}};g7.showCube=function(o){if(dU&&dU.objects&&dU.cube){if(o===b){o=(dU.cube.visible===false)}var hH;if(o){if(dU.cube.visible!==true){dU.cube.visible=true;hH=true}}else{if(dU.cube.visible!==false){dU.cube.visible=false;hH=true}}if(hH){hq()}}};var fu=function(o){if(!this.FSIHotspot){return}var hI=o.type;var hH=this;if(hH.FSIHotspot._nTimeoutEvent!==b){clearTimeout(hH.FSIHotspot._nTimeoutEvent);hH.FSIHotspot._nTimeoutEvent=b}if(hI==="mouseleave"){this.FSIHotspot._nTimeoutEvent=setTimeout(function(){f5(hI,hH,o)},10)}else{f5(hI,hH,o)}};var f5=function(hL,hJ,hQ){var hN=false;var hH=hJ.FSIHotspot;if(!hH||!hL){return false}var o;switch(hL){case"mouseenter":if(!hH._bMouseOver){o=true;hL="mouseover";hH._bMouseOver=true}else{return}break;case"mousedown":o=true;break;case"mouseleave":if(hH._bMouseOver){o=true;hL="mouseout";hH._bMouseOver=false}else{return}break;default:o=true}if(gD){var hM=hH.FSIHotspotID;var hK=hH.tooltip;var hP=hH.actionParameter;var hO=gD(hL,bk,S,hM,hK,hP,hH.perimeterAngleY,hH.perimeterAngleX);if(hO===true){hN=true}}var hR=cM.run("onHotspotEvent",[hL,hH.FSIHotspotID,hH.id,hH.text,hJ,hQ]);if(hR!==false){if(o){switch(hL){case"mouseover":a.addClassSVG(hH.marker,hH.hoverClass);a.addClass(hH.tooltip,hH.hoverClass);hH.marker.style.zIndex=hH.tooltip.style.zIndex=5000000;break;case"mousedown":a.addClassSVG(hH.marker,hH.activeClass);a.addClass(hH.tooltip,hH.activeClass);break;case"mouseout":a.removeClassSVG(hH.marker,hH.hoverClass);a.removeClass(hH.tooltip,hH.hoverClass);hH.marker.style.zIndex=hH.tooltip.style.zIndex=hH.zIndex;break;default:a.removeClassSVG(hH.marker,hH.activeClass);a.removeClass(hH.tooltip,hH.activeClass)}}if(hL==="click"){if(hH.url){window.open(hH.url,hH.urlTarget);hN=true}if(!hN&&hH.focusOnClick===true){var hI=fs(hH);he(hI,true);hN=true}}}return hN};var fv=function(hI,hH,o){dU.objects.rotation.x=hI+gL.virtualSpace.baseRotationXRad;dU.objects.rotation.y=hH+gL.virtualSpace.baseRotationYRad;dU.objects.rotation.z=o+gL.virtualSpace.baseRotationZRad;if(aM){aM()}};var f9=function(){var o={projection:dU,drawRatioUnZoomed:bn,drawRatio:ad,viewport:bm,scenes:{sceneSets:a6,currentSceneSet:cY,nPreviewImages:e.length,nPreviewImageIndex:dv},virtualSpace:gL.virtualSpace,rotation:{x:dU.objects.rotation.x,y:dU.objects.rotation.y,z:dU.objects.rotation.z,xm:dU.objects.rotation.x-gL.virtualSpace.baseRotationXRad,ym:dU.objects.rotation.y-gL.virtualSpace.baseRotationYRad,zm:dU.objects.rotation.z-gL.virtualSpace.baseRotationZRad}};cM.run("on3DWorldChanged",[o])};var ap;g7.setHotSpotObjectID=function(o,hH){ap[hH]=o};g7.getHotSpotObject=function(o){return ap[o]};g7.projectVectorOnScreen=function(hJ){hJ.project(dU.camera);var hH=aC.left;var hK=aC.top;var o=bm.width/2;var hI=bm.height/2;return{vectorX:hJ.x,vectorY:hJ.y,x:hH+hJ.x*o+o,y:hK+hI-hJ.y*hI}};var bU=function(){var hZ,h0;var hS=new THREE.Vector3();var h2=aC.left;var h1=aC.top;var h3=bm.width/2;var hJ=bm.height/2;var hP;var hY=false;var hO;var h5=bm.width;var h4=bm.height;if(hp.spinFrame!==dv){hp.spinFrame=dv;if(hp.arSpotsAtFrame===b){hp.arSpotsAtFrame=new Array(ex)}var hX=hp.hotSpotsAtThisFrame;hp.hotSpotsAtThisFrame=hp.arSpotsAtFrame[dv];if(hp.hotSpotsAtThisFrame===b){var hN;if(cY.oSpinPositions){hN=gL.virtualSpace.rotationYRange*cY.oSpinPositions.arPositions[dv]}else{hN=gL.virtualSpace.rotationYRange*hz(eI)/ex}hp.hotSpotsAtThisFrame=hp.arSpotsAtFrame[dv]=[];for(h0=0;h0<gL.hotspots.points.length;h0++){hO=gL.hotspots.points[h0];hP=1;if(hO.perimeterAngleY!==b){var h6=Math.abs(hO.perimeterAngleY-hN);if(h6>180){h6=Math.abs(360-h6)}if(h6<hO.perimeterAngleYRange){if(h6>hO.perimeterAngleYRange-hO.perimeterAngleYFadeOut){hP=(hO.perimeterAngleYRange-h6)/hO.perimeterAngleYFadeOut}}else{hP=0}}if(hP!==0){var hW={};hW.index=h0;hW.hotspot=hO;hW.op=hP;hp.hotSpotsAtThisFrame.push(hW);hS.setFromMatrixPosition(hO.object.matrixWorld);hO.zIndex=hW.zIndex=Math.round(hS.z);if(!hO._bMouseOver){hO.marker.style.zIndex=hO.tooltip.style.zIndex=hO.zIndex}}}}if(hX&&hX.length>0){var hV={};for(hZ=0;hZ<hp.hotSpotsAtThisFrame.length;hZ++){var hH=hp.hotSpotsAtThisFrame[hZ];hO=hH.hotspot;if(!hO._bMouseOver){hO.marker.style.zIndex=hO.tooltip.style.zIndex=hO.zIndex}hV[hH.index]=hO.bVisible}for(hZ=0;hZ<hX.length;hZ++){if(!hV[hX[hZ].index]){bR(hX[hZ].hotspot,false)}}}}if(hp.scale!==hj){hp.scale=hj;hY=true}for(h0=0;h0<hp.hotSpotsAtThisFrame.length;h0++){var hI=hp.hotSpotsAtThisFrame[h0];hO=hI.hotspot;hP=1;if(cY.visibleHotSpots){hP=cY.visibleHotSpots[hO.FSIHotspotID]}hP=hP*hI.op;if(!hY&&hO._opScale!==b){if(hO._opScale===0){hP=0}}else{hO._opScale=1;if(gL.enableZoom&&hO.perimeterZoom!==b){if(hj<hO.perimeterZoom){hP=hO._opScale=0}}if(hP!==0&&hO.perimeterImageWidth!==b){if(hp.testWidth<hO.perimeterImageWidth){hP=hO._opScale=0}}}if(hP!==0){hS.setFromMatrixPosition(hO.object.matrixWorld);hS.project(dU.camera);var hL=Math.round(h2+hS.x*h3+h3);var hK=Math.round(h1+hJ-hS.y*hJ);if(cd.enabled){if(hL<0||hK<0||hL>h5||hK>h4){hP=0}}}if(hP!==0){bR(hO,true);if(hO._opacity!==hP){hO._opacity=hP;hO.marker.style.opacity=hO.tooltip.style.opacity=hP}var hQ=hO.oSvg;hO.tooltip.style.left=hL+hQ.endX+(hO.tooltip.offsetWidth*hQ.xAlign)+"px";hO.tooltip.style.top=hK+hQ.endY+(hO.tooltip.offsetHeight*hQ.yAlign)+"px";hO.marker.style.left=hL+hQ.startX+"px";hO.marker.style.top=hK+hQ.startY+"px";if(hO.elSVGIcon){if(!hO._bIconCentered){hO._bIconCentered=true;var hM=hO.elSVGIcon.getBBox();var hU=-hM.x-hM.width/2;var hT=-hM.y-hM.height/2;var hR="translate("+(hO._data.x1+hU)+","+(hO._data.y1+hT)+")";hO.elSVGIcon.setAttribute("transform",hR)}}}else{bR(hO,false)}}};var aX=function(hJ,hO,hH,hN,o,hM,hK,hI,hL){if(hI===b){hI=bE}if(hL===b){hL=1}var hP=document.createElementNS(dJ,"polyline");hP.setAttribute("points",hJ+","+hO+" "+hH+","+hN+" "+o+" , "+hM+" "+hH+","+hN+" "+hJ+","+hO);hP.setAttribute("stroke",hK);hP.setAttribute("stroke-width",hI);hP.setAttribute("stroke-opacity",hL);hP.setAttribute("stroke-linecap","square");return hP};var a2=function(){var hH=aP=document.createElementNS(dJ,"svg");try{if(!hH.style){aP=b;dF.log("ERROR: SVG Gradient not supported");return false}}catch(hJ){aP=b;dF.log("ERROR: SVG Gradient not supported");return false}var hM=a.utils.getSVGID();var hI=gL.hotspotDotRadius;hH.setAttribute("xmlns",dJ);hH.setAttribute("version",f4);hH.setAttribute("baseProfile","tiny");var o=bW=hH.cloneNode(true);try{var hO=document.createElementNS(dJ,"radialGradient");hO.setAttribute("id",hM);hO.setAttribute("cx","0.5");hO.setAttribute("cy","0.5");hO.setAttribute("r","0.5");var hN=document.createElementNS(dJ,"stop");hN.setAttribute("stop-color",gL.hotspotDotColor1);hN.setAttribute("offset","0.5");var hL=document.createElementNS(dJ,"stop");hL.setAttribute("stop-color",gL.hotspotDotColor2);hL.setAttribute("offset","1");hO.appendChild(hN);hO.appendChild(hL);o.appendChild(hO);o.style.position="absolute";o.style.width="0px";o.style.height="0px";o.style.left="0";o.style.top="0";o.style.zIndex=-500000;o.style.visibility="hidden";ac.appendChild(o)}catch(hJ){dF.log("ERROR: SVG Gradient not supported")}var hK=document.createElementNS(dJ,"circle");hK.setAttribute("class","fsi-ui-hotspot-spot");hK.setAttribute("r",hI);hK.setAttribute("stroke",gL.hotspotLineColor2);hK.setAttribute("stroke-width","1px");hK.setAttribute("stroke-opacity","0.85");hK.setAttribute("fill","url(#"+hM+")");hK.setAttribute("fill-opacity","0.5");hH.appendChild(hK);return true};var bf=function(hM){var hQ=hM.horizontalMarkerSize;var hU=Math.abs(hM.verticalMarkerSize);var hY;if(!aP){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var hO=hM.markerAngle*Math.PI/180;var hV,hK,hT,hJ,hR,hI;var h0={};var hL=h0.radius=gL.hotspotDotRadius+1;hY=Math.max(0,Math.min(1,hM.horizontalMarkerPosition));if(hY>0.5){hQ=-hQ}h0.xAlign=-hY;hY=Math.max(0,Math.min(1,hM.verticalMarkerPosition));h0.yAlign=-hY;hV=0;hK=0;hT=hV+Math.sin(hO)*hU;hJ=hK-Math.cos(hO)*hU;hR=hT+hQ;var hW=Math.min(hV-hL,hT);var o=Math.min(hK-hL,hJ);hW=Math.min(hW,hR);hV-=hW;hT-=hW;hR-=hW;hK-=o;hJ-=o;hI=hJ;h0.startX=-hV;h0.startY=-hK;h0.endX=h0.startX+hR;h0.endY=h0.startY+hI;var hZ=Math.max(hV+hL,hT);hZ=Math.max(hZ,hR);var hH=Math.max(hK+hL,hJ);var hP=h0.svg=aP.cloneNode(true);var hN=h0.width=hZ;var hS=h0.height=hH;hP.setAttribute("width",hN);hP.setAttribute("height",hS);hP.setAttribute("viewBox","0 0 "+hN+" "+hS);hP.setAttribute("class","fsi-ui-hotspot-line");var hX=hP.firstChild;hX.setAttribute("cx",hV);hX.setAttribute("cy",hK);hM._data={x1:hV,y1:hK,};hV+=Math.sin(hO)*hL;hK-=Math.cos(hO)*hL;hP.appendChild(aX(hV,hK,hT,hJ,hR,hI,gL.hotspotLineColor1,"5px","0.25"));hP.appendChild(aX(hV,hK,hT,hJ,hR,hI,gL.hotspotLineColor2,"1px"));return h0};var bR=function(hH,o){if(hH.bVisible===o){return}hH.bVisible=o;if(o){hH._opacity=b;hH.marker.style.display="block";if(!hH.tooltip.FSIEmpty){hH.tooltip.style.display="block"}}else{hH.marker.style.display="none";if(!hH.tooltip.FSIEmpty){hH.tooltip.style.display="none"}hH._opacity=0;hH.marker.style.opacity=hH.tooltip.style.opacity=0}};var dx=function(hM){var hH;var hL=bf(hM);if(!hM.text){hH=document.createElement("div");hH.style.display="none";hH.FSIEmpty=true;while(hL.svg.firstChild){hL.svg.removeChild(hL.svg.firstChild)}}else{hH=document.createElement("div");var hJ="fsi-ui-hotspot";if(ce){hJ+=" "+ce}if(hM.cssClass!==b&&hM.cssClass.length>0){hJ+=" "+hM.cssClass}if(hM.normalClass.length>0){hM.normalClass=hJ+" "+hM.normalClass}else{hM.normalClass=hJ}if(hM.hoverClass.length>0){hM.hoverClass="fsi-ui-hotspot-hover "+hM.hoverClass}else{hM.hoverClass="fsi-ui-hotspot-hover"}if(hM.activeClass.length>0){hM.activeClass="fsi-ui-hotspot-active "+hM.activeClass}else{hM.activeClass="fsi-ui-hotspot-active"}hH.className=hM.normalClass;var hK="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+hM.cssStyle;a.utils.setStyleAttr(hH,hK);hH.innerHTML=hM.text;if(gL.decodeHTMLEntitiesInHotSpotTexts){hH.innerHTML=hH.innerText}}if(hM.icon){var hN=document.createElementNS(dJ,"g");hN.innerHTML=a.trim(hM.icon);hN.setAttribute("class","fsi-viewer-hotspot-icon");hM.elSVGIcon=hN;hL.svg.appendChild(hN);hL.svg.style.overflow="visible";if(hM.iconScaleX!==1||hM.iconScaleY!==1){hM.elSVGIcon.firstChild.setAttribute("transform-origin","center center");var hI="scale("+hM.iconScaleX+","+hM.iconScaleY+")";hM.elSVGIcon.firstChild.setAttribute("transform",hI)}}var o;if(hL&&hL.svg){o=hL.svg;o.style.position="absolute";ac.appendChild(o);o.FSIHotspot=hM;if(hM.interactive){a.addEvent(o,"mouseenter",fu);a.addEvent(o,"mouseleave",fu)}}else{o={style:{}}}ac.appendChild(hH);if(hM.interactive){hH.FSIHotspot=hM;if(!hH.FSIEmpty){a.addEvent(hH,"mouseenter",fu);a.addEvent(hH,"mouseleave",fu)}}else{hH.style.zIndex="1"}hM.bVisible=false;hM.tooltip=hH;hM.marker=o;hM.oSvg=hL;hH.style.display="none";o.style.display="none"};var c7=function(o){aI();var hH=true;var hI=(ex&&!df);fE=o.shiftKey;switch(o.keyCode){case 37:if(hI){b0();dO=1;hg(en+dP)}hH=false;break;case 39:if(hI){b0();dO=-1;hg(en-dP)}hH=false;break;case 32:hH=false;break}if(!hH&&o.preventDefault){o.preventDefault()}return hH};var ct=function(o){fE=o.shiftKey;if(dF&&dF.on){if(!fE){b7(b8)}}var hH=true;var hI=(ex&&!df);switch(o.keyCode){case 37:if(hI){eU(eI,true)}hH=false;break;case 39:if(hI){eU(eI,true)}hH=false;break;case 32:bk.resetView();hH=false;break}if(!hH){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return hH};this.resetView=function(o){if(o===b){o=true}aI(false);eG();dy=bL;if(gL.initialview&&gL.initialViewPersistent){he(gL.initialview,o)}else{he("1,1,0,0,1,1",o)}dy=bL};this.spinToDegree=function(o){if(!cv){return}var hH=hz(Math.round(o/360*ex));bk.spinToTarget(hH)};this.spinToTarget=function(hJ,hM,hK){if(!cv){return}hJ=dr(hJ);var hP=hz(eI);var hL=hJ-hP;var o=(hM!==b&&!isNaN(hM)&&hM!==a6.nCurrent);if(hL===0&&!o){eq(hJ,hJ,0,0);return true}var hO;if(hL!==0){dO=(hL>0)?1:-1;hO=hP;if(!gL.noSceneLoop){if(Math.abs(hL)>ex/2){if(dO>0){hJ-=ex}else{hO-=ex}dO=-dO;hL=Math.abs(hJ-hO)}}}else{hO=hJ}var hH=a6.nCurrent;var hN;if(o&&!gL.noSetLoop&&a6.nSceneSets>1){hN=hM-a6.nCurrent;if(Math.abs(hN)>a6.nSceneSets/2){if(hN>0){hM-=a6.nSceneSets}else{hH-=a6.nSceneSets}}}b0();if(hK===b||isNaN(hK)){hK=4;if(hL!==0){hK=Math.ceil(0.2*360/ex*Math.abs(hL))}if(o){hN=Math.abs(hM-hH);var hI=Math.ceil(0.1*360/a6.nSceneSets*hN);hK=Math.max(hK,hI)}}eq(hO,hJ,0,hK,hH,hM);return true};var ae=function(o){if(a6.nSceneSets<2){return 0}if(gL.noSetLoop){o=Math.max(0,Math.min(a6.nSceneSets-1,o))}else{o=o%a6.nSceneSets;if(o<0){o=a6.nSceneSets+o}}return o};var d9=function(){cY={};a6.bSetCameraPosition=false;a6.initialScene=a6.initialSceneSet=a6.nCurrent=0;a6.arCurrentSetIndex=false;bJ=ak=hi.length;cW=(e.length>0)?e.length:bJ;a0(cW);a1=false};var bt=function(){if(a6.bHasMultipleSets||!a6.bDefault){a0(a6.quantizeMax);ak=a6.quantizeMax;a6.nCurrent=b;f1(0)}else{d9()}};var f1=function(hI){hI=ae(hI);if(hI===a6.nCurrent){return}a6.nCurrent=hI;cY=a6.arSets[hI];var hH=a6.arCurrentSetIndex=a6.arSets[hI].arScenes;a1=hH;bJ=a6.quantizeMaxImages;cW=bJ;if(a6.nVideoSet!==b){if(a6.nVideoSet===hI){ak=bJ=hH.length;cW=dM;if(gr){gr.setPreviewImageSize(c2.croppedWidth,c2.croppedHeight)}if(!fr){ew("video",true)}a1=b}else{if(gr){gr.setPreviewImageSize()}ak=a6.quantizeMax;if(fr){ew("image",true)}}}fq();dR();var o=eI;eW=eI=b;if(du){du.spinPos=b}cm(o);hq();return hI};var fq=function(){if(!a6.bSetCameraPosition||!cY.posCamera){return}var o=cY.posCamera;dU.camera.position.set(o.x,o.y,o.z);dU.camera.lookAt(dU.targetObj.position);dU.camera.rotation.z=0};var a8=function(o){o=Math.max(0,Math.min(ex-1,o));return o};var fa=function(o){o%=ex;if(o<0){o=ex+o}return o};var dr=function(hH,hK){if(!hd){return hH}var hJ;var o=ex/bJ;var hI=Math.round(hH/o)*o;if(!hK||hH===hI){hJ=hI}else{if(dO===1){hJ=Math.round(hI+o)}else{hJ=Math.round(hI-o)}}hJ=hz(hJ);return hJ};var eU=function(o,hJ){var hH=(o!==b)?o:eI;var hI=dr(hH,hJ);bk.spinToTarget(hI)};var eq=function(o,hK,hL,hJ,hI,hH){o=Math.round(o);hK=Math.round(hK);b0();if(hH!==b&&!isNaN(hH)&&hH!==a6.nCurrent){if(hI===b){hI=a6.nCurrent}}else{hI=b}if(o!==hK||hI!==hH){if(bu(o,hK,hL,hJ,hI,hH)){b9("spinToFrame")}else{gz("doSpinToFrame")}}else{gz("doSpinToFrame")}};var b0=function(){if(fL===b){return}cancelAnimationFrame(fL);fL=b;gz("cancelSpinToFrame")};var bu=function(hK,hQ,hP,hL,hH,hN){var hO=hQ-hK;var hM;if(hO===0){hM=hQ}else{hM=dV(hP,hL,hK,hO)}var hJ;if(hH!==b){var hI=hN-hH;hJ=Math.round(dV(hP,hL,hH,hI))}if(hP!==hL){if(e3){e3.lockImageSourceDimension(b4,true);e3.lockImage(b4,true)}var o=Math.round(hM);if(o<0){o=ex+o}else{if(o===ex){o=0}}fL=requestAnimationFrame(function(){if(hH!==b){f1(hJ)}if(o!==eI){dR();cm(o);hq()}bu(hK,hQ,++hP,hL,hH,hN)});return true}else{fL=b;if(e3){e3.lockImage(b4,false)}cm(hz(hQ));if(hN!==b){f1(hN)}cj();co();gz("doSpinToFrame")}};var cj=function(){cm(hz(eI));hq();if(i){ft()}};var g5=function(hH){var o={};o.baseURL=gx.getImageURL(hi[hH],fo);o.fullURL=o.baseURL+g8;return o};var fz=function(){if(!du){return}cr=b;du=b;bp=b;Y=true;V();ej()};var ej=function(){aT.abortPurpose("tile")};var bX=function(){if(bF===bT){return}bF=bT;var o=fB.getPixelRangeRect(bT);g8=fB.getPixelRangeParametersByCalculatedResult(o)};var aK=function(o){if(o===b){o=Math.round(eI/(ex/ak))}if(isNaN(o)||o<0||o>=ak){dF.error("invalid image index in loadHDImage "+o);return}if(a6.arCurrentSetIndex){o=a6.arCurrentSetIndex[o]}o-=dM;return o};var ft=function(hT){if(i&&!fr&&hj<=1){fz();return}if(fe||cr===bT){return}cr=bT;hT=aK(hT);bX();var o=g5(hT);if(bp===o.fullURL){return}if(du&&o.fullURL===du.src){return}cB={};cB.img=new Image();cB.nImage=hT;cB.renderScale=hj;var hH=ex/bJ;cB.spinPos=dr(hT*hH);cB.img.crossOrigin="anonymous";cB.img.FSI_ImageObject=cB;bp=cB.src=o.fullURL;if(i){Y=true;cB.bTilesFading=false;cB.bFillsViewport=false;var hO=e4.width;var hN=e4.height;var hM=bT;var hK=Math.round(hM/hO*hN);ej();cB.width=hM;cB.height=hK;var hU=fJ;cB.tiles=[];var hR=0;var hP=0;var hS=hU;var hQ=hU;hS=Math.min(hS,hM);hQ=Math.min(hQ,hK);var hJ;var hI=false;while(hP<hK){hJ={};hJ.fnDraw=ez;hJ.FSI_ImageObject=cB;hJ.x=hR;hJ.y=hP;if(hR+hS>=hM){hJ.width=hM-hR;hS=Math.min(hU,hM-hR);hI=true}hJ.width=hS;hJ.height=hQ;var hL=fB.getPixelRangeParameters(hM,hK,hR,hP,hS,hQ);hJ.url=o.baseURL+hL;if(hI){hI=false;hP+=hU;hR=0;hS=hU;if(hP+hU>hK){hQ=Math.min(hU,hK-hP)}}else{hR+=hU}cB.tiles.push(hJ)}cB.nTiles=cB.tiles.length;cB.arVisibleTiles=new Array(cB.nTiles);cB.nVisibleTiles=0;cB.nTilesLoading=0;cB.nTilesLoaded=0;cB.nTilesRequested=0;cB.nTileColumns=Math.ceil(hM/hU);cB.nTileRows=Math.ceil(hK/hU);C=true;W(null,cB)}};var ep=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;gc(o.img,o.url,"tile",bg)};var bg=function(){a.removeEvent(this,"load",bg);var hH=this.oTile;hH.bLoading=false;hH.bLoaded=true;var o=hH.FSI_ImageObject;if(o.nTilesLoaded===o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!==bp){return}hH.alpha=0;hH.fnDraw=g2;o.nTilesLoading--;o.nTilesLoaded++;W(null,o);cz(this);hq();c5(25)};var ci=function(hH,o){return o.distance-hH.distance};var hc=function(){C=false;if(!du){return}var hN=du;var hX,hW,hI,o;var hM;if(cd.enabled){fG.setRect(0,0,bm.width,bm.height);fG.scaleRect(1/cd.scale);fG.offsetRect(-cd.panPos.left/hj,-cd.panPos.top/hj);fG.offsetRect((bm.width-fG.width())/2,(bm.height-fG.height())/2);dT.copyRect(bb);dT.scaleRect(1/cd.scale);dT.offsetRect(fG.left,fG.top);hM=dT}else{hM=bb}cu(hM);hX=f0.left;hW=f0.top;hI=f0.right;o=f0.bottom;var hT=Math.max(0,Math.floor(hX/fJ));var hJ=Math.min(hN.nTileColumns-1,Math.floor(hI/fJ));var hS=Math.max(0,Math.floor(hW/fJ));var hH=Math.min(hN.nTileRows-1,Math.floor(o/fJ));var hK=hJ-hT+1;var hO=hH-hS+1;var hP=Math.max(0,hO)*hK;if(hN.nFirstTileXLastGetVisible===hT&&hN.nFirstTileYLastGetVisible===hS&&hN.nTilesLastGetVisible===hP){return}hN.nFirstTileXLastGetVisible=hT;hN.nFirstTileYLastGetVisible=hS;hN.nTilesLastGetVisible=hP;var hZ=hN.tiles;var hY=hN.arVisibleTiles;var hQ=hS*hN.nTileColumns;var hL=hT;var hR;var hV=hx;for(var hU=0;hU<hP;hU++){hR=hY[hU]=hZ[hQ+hL];if(!hV&&hR.alpha!==1){hV=true}if(++hL>hJ){hL=hT;hQ+=hN.nTileColumns}}hN.nVisibleTiles=hP;hN.bFilesArePreparedForLoading=false;if(hV&&!Y){cC.globalAlpha=1;gi()}if(hV){Y=hV}c5(50)};var V=function(){if(gO){clearTimeout(gO);gO=b}};var c5=function(o){if(gO!==b){return}if(!du||du.bRequestsComplete){return}gO=setTimeout(gZ,o)};var gZ=function(){V();G()};var G=function(){if(X){return}var hK=du;if(hK.nTilesLoading>=e0){return}var hN,hI,hH,hJ,hM;if(!hK.bFilesArePreparedForLoading){hK.bFilesArePreparedForLoading=true;if(!hK.arTilesToLoad||hK.arTilesToLoad.length!==0){hK.arTilesToLoad=[]}hN=hK.arTilesToLoad;var hL=hK.arVisibleTiles;for(hJ=0;hJ<hK.nVisibleTiles;hJ++){if(!hL[hJ].bLoaded&&!hL[hJ].bLoading){hN.push(hL[hJ])}}if(hN.length>1){cd.centerX=f0.left+f0.width()/2;cd.centerY=f0.top+f0.height()/2;for(hJ=0;hJ<hN.length;hJ++){hM=hN[hJ];hI=hM.x-cd.centerX+hM.width/2;hH=hM.y-cd.centerY+hM.height/2;hM.distance=Math.abs(hI)+Math.abs(hH)}hN.sort(ci)}}var o=0;hN=hK.arTilesToLoad;while(hK.nTilesLoading<e0&&hN.length>0){hM=hN.pop();ep(hM);o++;hK.nTilesLoading++}hK.nTilesRequested+=o;if(hK.nTilesRequested===hK.nTiles){hK.bRequestsComplete=true}};var W=function(o,hH){if(hH===b){a.removeEvent(this,"load",W);hH=this.FSI_ImageObject;hH.width=this.width;hH.height=this.height}if(hH.src!==bp){return}cz(this);du=hH;if(hE){return}if(gE){hq()}};this.clickMenuButton=function(o){g7.pressMenuButton(o,b,true);g7.releaseMenuButton(o,b,true);g7.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){c0.pressButton(o)};this.releaseMenuButton=function(o){c0.releaseButton(o)};g7.onUserAction=function(){};g7.getInteractive=function(){return cv};g7.pressMenuButton=function(hI,o,hK){if(!hK){g7.onUserAction()}if(hI!=="ToggleAutoSpin"&&hI!=="ToggleFullScreen"){aI()}eG();bZ();var hH,hJ;if(hI.indexOf("_")!==-1){hH=hI.split("_");hI=hH[0];hJ=hH[1]}switch(hI){case"ToggleCube3D":g7.showCube(b);break;case"Reset":bk.resetView();break;case"ZoomOut":case"ZoomIn":ah(hI,150,10);break;case"MouseMode":fm(parseInt(hJ));break;case"MaxZoom":fS(b,b,cd.scaleToSourceImage-cd.scale,false,30);break}};var cI=function(hH,o){if(!c0){return false}return c0.enableButton(hH,o)};g7.releaseMenuButton=function(hH,o,hI){if(!hI){g7.onUserAction()}bZ()};g7.clickMenuButton=function(hJ,o,hL){var hH,hK;if(typeof(hJ)==="string"&&hJ.indexOf("_")!==-1){hH=hJ.split("_");hJ=hH[0];hK=hH[1]}switch(hJ){case"ToggleFullScreen":if(a.FullScreen.getEnabled()){a.FullScreen.quit();dC()}else{var hI=fK();d1=hI;a.FullScreen.start(hI);dC()}break;case"HotSpots":dt=c0.getButtonPressed("HotSpots");gf(dt);break;case"ToggleAutoSpin":gR();break}};var al=function(hH){if(!cd.enabled){return}var o=hj;gg(hH);cd.panPos.left*=hj/o;cd.panPos.top*=hj/o;cb(true)};var fI=function(hH){var o;if(!hH){hH=bP.cmd;bP.nRepeatCount++}switch(hH){case"ZoomOut":o=(bP.nRepeatCount<1)?1.01:1.035;al(cd.scale/o);break;case"ZoomIn":o=(bP.nRepeatCount<1)?1.01:1.035;al(cd.scale*o);break}if(bP.nRepeatCount===1){if(bP.intervalTimeFirst!==bP.intervalTimeRepeat){clearInterval(bP.interval);bP.interval=setInterval(fI,bP.intervalTimeRepeat)}}};var ah=function(hI,o,hH){aW(false);bZ();bP={};bP.bRunning=true;if(o===b){o=500}bP.intervalTimeFirst=o;if(hH===b){bP.intervalTimeRepeat=o}else{bP.intervalTimeRepeat=hH}bP.nRepeatCount=0;bP.cmd=hI;bP.interval=setInterval(fI,bP.intervalTimeFirst);fI(hI)};var bZ=function(){if(!bP.bRunning){return}aW(true);clearInterval(bP.interval);switch(bP.cmd){case"ZoomOut":case"ZoomIn":e2();break}bP={}};var e1=function(o){if(Z!==b){if(Z.width!==bn.imageWidth){bM()}else{return}}if(fM>0&&e.length===fM){return}bM();aT.abortPurpose("asyncResize");Z={};Z.width=bn.imageWidth;Z.previewImageCanvasWidthBeforeResize=o;Z.uniqueInstanceID=au;Z.nTimeout=setTimeout(ee,50)};var ee=function(){if(!cv){Z.nTimeout=setTimeout(ee,250);return}Z.nTimeout=b;Z.img=new Image();a.addEvent(Z.img,"load",at);a.addEvent(Z.img,"error",at);var hI=0;var hH=dv;Z.pos=0;Z.arIndex=new Array(hi.length);if(hH>=fM){Z.arIndex[0]=hH;hI+=1}for(var o=fM;o<e.length;o++){if(o!==dv){Z.arIndex[hI++]=o}}at()};var at=function(o){if(o!==b){if(!Z||Z.uniqueInstanceID!==au){return}a.removeEvent(Z.img,"load",at);cz(Z.img);e[Z.indexCurrent]=Z.img;if(Z.indexCurrent===dv){aH=b;da=b;eW=b;b5(Z.indexCurrent);hq()}Z.img=new Image();a.addEvent(Z.img,"load",at)}Z.indexCurrent=Z.arIndex[Z.pos];Z.pos++;if(Z.pos>hi.length){bM()}else{var hH=bT;bT=aN;bX();Z.url=g5(Z.indexCurrent-dM).fullURL;bT=hH;bX();Z.nTimeout=setTimeout(dn,25)}};var dn=function(){gc(Z.img,Z.url,"asyncResize")};var bM=function(){if(Z===b){return}if(Z.nTimeout){clearTimeout(Z.nTimeout);Z.nTimeout=b}a.removeEvent(Z.img,"load",at);a.removeEvent(Z.img,"error",at);Z=b};var cZ=function(){dC()};var a5=function(){dF.error("ERROR entering FullScreen")};this.setFullScreenElement=function(o){if(ei){dC();a.FullScreen.quit()}dL=gx.cfg.fullscreenelement=o};var dC=function(){var o=a.FullScreen.getEnabled();if(o&&eV()){return}if(o===ei){return}if(c0){c0.setButtonPressed("ToggleFullScreen",o)}cM.runPersistent("onFullScreen",[o]);ei=o;a.setCustomEventListenerProperty(g3,"skiptreshold",true);if(m){bk.showAboutWindow()}if(o){a.addClass(d1,"fsi-fullscreen-element")}else{a.removeClass(d1,"fsi-fullscreen-element")}if(!o){d1=b}if(o){cL()}else{if(fT.bRestore){gj();if(gh.bEnabledByConfig){setTimeout(fQ,0)}}}};this.getInFullScreenMode=function(){return ei};this.getSpinFrames=function(){return ex};this.getImageIsTransparent=function(){return dX};this.getSrcDim=function(){return e4};if(typeof(et)!=="object"||a.makeBool(et.autoInit,true)){bk.init(gC,et)}};a.customTags.register("fsi-viewer",{constructorClass:a.Viewer,viewerCSS:"display:block;width:300px;height:300px;",parameterAliases:{src:"imagesrc"}});a.dispatchEvent("FSIViewerLoaded")}(window.$FSI=window.$FSI||{}));